<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\Estacionamiento;
use App\Repositories\EstacionamientoRepository;
use Illuminate\Http\Request;

class EstacionamientoAPIController extends Controller
{
    private $estacionamientoRepository;
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct(EstacionamientoRepository $estacionamientoRepository)
    {
        $this->estacionamientoRepository = $estacionamientoRepository;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Vehiculo  $vehiculo
     * @return \Illuminate\Http\Response
     */
    public function show()
    {
        //
    }


    public function getEstacionamiento($idsucursal){
        $estacionamiento = Estacionamiento::where('idsucursal', $idsucursal)->join('sucursal', 'sucursal.id', '=' , 'estacionamiento.idsucursal')
                                                                            ->select('estacionamiento.*', 'sucursal.nombre as NombreSucursal')->where('estacionamiento.activo', '=', true)->get();

        if(empty($estacionamiento)){
            return $this->sendError('No hay estacionamientos asignados a esta sucursal');
        }else {
            return $this->sendResponse($estacionamiento, 'Lista de estacionamientos de esta sucursal');
        }   

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Vehiculo  $vehiculo
     * @return \Illuminate\Http\Response
     */
    public function edit()
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Vehiculo  $vehiculo
     * @return \Illuminate\Http\Response
     */
    public function update()
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Vehiculo  $vehiculo
     * @return \Illuminate\Http\Response
     */
    public function destroy()
    {
        //
    }
}
