<?php

namespace App\Http\Controllers\Api;

use Carbon\Carbon;
use App\Models\Eventos;
use App\Models\EventoCosto;
use Illuminate\Http\Request;
use App\Models\EventoDescuentoNivel;
use App\Http\Controllers\Controller;
use App\Models\EventoDescuentoEspecial;

class EventosController extends Controller
{
    public function eventos_activos()
    {
            try
            {
                // Obtener la fecha actual usando Carbon
                $currentDate = Carbon::now()->format('Y-m-d');
            
                // Obtener los eventos donde la fecha es mayor o igual a la fecha actual
                $eventos = Eventos::where('fecha', '>=', $currentDate)->get();
            
                // Iterar sobre los eventos y agregar los datos adicionales
                foreach ($eventos as $evento) 
                {
                    $evento->costos = EventoCosto::where('id_evento', $evento->id)->get();
                    $evento->descuentos_nivel = EventoDescuentoNivel::where('id_evento', $evento->id)->get();
                    $evento->descuentos_especiales = EventoDescuentoEspecial::where('id_evento', $evento->id)->get();
                    $evento->imagen = asset($evento->imagen);
                }
            
                return $this->sendResponse($eventos, "Eventos activos");

            }
            catch(ValidatorException $e)
            {
                return $this->sendError("No está jalando:" . $e->getMessage(), 401);
            }

        //return $eventos;
               
    }
}
