<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\Linea;
use App\Repositories\LineaRepository;
use Illuminate\Http\Request;


class LineaAPIController extends Controller
{
    private $lineaRepository;
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct(LineaRepository $lineaRepository)
    {
        $this->lineaRepository = $lineaRepository;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        $this->validate($request, [
            'nombre' => 'required',

        ]);

        try {
            $linea = $this->lineaRepository->create(array(
                'nombre' => $request->nombre,
				'activo' => true,
				'codigo' => '1',
            ));


		} catch (ValidatorException $e) {
            return $this->sendError($e->getMessage(), '401');
        }

        return $this->sendResponse($linea->toArray(), utf8_encode('Lnea agregada correctamente'));
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Linea  $linea
     * @return \Illuminate\Http\Response
     */
    public function show(Linea $color)
    {
        //
    }


    public function getLinea(){
        $lineas = $this->lineaRepository->all();
        if ($lineas->isEmpty()) {
            return $this->sendError(utf8_encode('No hay lneas disponivles'));
        } else {
            return $this->sendResponse($lineas, 401);
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Linea  $linea
     * @return \Illuminate\Http\Response
     */
    public function edit(Linea $linea)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Linea  $linea
     * @return \Illuminate\Http\Response
     */
    public function update()
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Linea  $linea
     * @return \Illuminate\Http\Response
     */
    public function destroy(Linea $linea)
    {
        //
    }
}