<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\Reclamo;
use App\Repositories\ReclamoRepository;
use Illuminate\Http\Request;


class ReclamoAPIController extends Controller
{
    private $reclamoRepository;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct(ReclamoRepository $reclamoRepository)
    {
        $this->reclamoRepository = $reclamoRepository;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        $this->validate($request, [
            'idcliente' => 'required',
			'idempleado' => 'required',
			'idticket' => 'required',
			'comentarios' => 'required',


        ]);

        try {
            $reclamo = $this->reclamoRepository->create(array(
                'idcliente' => $request->idcliente,
                'idempleado' => $request->idempleado,
				'idticket' => $request->idticket,
                'comentarios' => $request->comentarios,
				'status' => '1',
            ));


		} catch (ValidatorException $e) {
            return $this->sendError($e->getMessage(), '401');
        }

        return $this->sendResponse($reclamo->toArray(), 'El reclamo ha sido registrado');
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Linea  $linea
     * @return \Illuminate\Http\Response
     */
    public function show(Reclamo $reclamo)
    {
        //
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Linea  $linea
     * @return \Illuminate\Http\Response
     */
    public function edit(Reclamo $reclamo)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Linea  $linea
     * @return \Illuminate\Http\Response
     */
    public function update()
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Linea  $linea
     * @return \Illuminate\Http\Response
     */
    public function destroy(Reclamo $reclamo)
    {
        //
    }
}