<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\TipoIndentificacion;
use App\Repositories\TipoIndentificacionRepository;
use Illuminate\Http\Request;


class TipoIndentificacionAPIController extends Controller
{
    private $tipoIndentificacionRepository;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct(TipoIndentificacionRepository $tipoIndentificacionRepository)
    {
        $this->tipoIndentificacionRepository = $tipoIndentificacionRepository;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {

		$this->validate($request, [
            'nombre' => 'required',

        ]);

        try {
            $marca = $this->colorRepository->create(array(
                'nombre' => $request->nombre,
				'activo' => true,
				'codigo' => '1',

            ));


		} catch (ValidatorException $e) {
            return $this->sendError($e->getMessage(), '401');
        }

        return $this->sendResponse($marca->toArray(), 'Pais Civil agregado correctamente');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Color  $color
     * @return \Illuminate\Http\Response
     */
    public function show(Pais $pais)
    {
        //
    }


    public function getTiposIndentificacion(){
        $tiposIdentificacion = $this->tipoIndentificacionRepository->all();

        if ($tiposIdentificacion->isEmpty()) {
            return $this->sendError('Lista de Tipos de Indentificacion vacia');
        } else {
            return $this->sendResponse($tiposIdentificacion, 401);
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Color  $color
     * @return \Illuminate\Http\Response
     */
    public function edit(TiposIdentificacion $tiposIdentificacion)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\color  $color
     * @return \Illuminate\Http\Response
     */
    public function update()
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Color  $color
     * @return \Illuminate\Http\Response
     */
    public function destroy(TiposIdentificacion $tiposIdentificacion)
    {
        //
    }
}
