<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Sucursal;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;


class UserAPIController extends Controller
{
    function login(Request $request)
    {
        try {
            $this->validate($request, [
                'codigo' => 'required',
                'password' => 'required',
            ]);
            if (Auth::guard()->attempt(['codigo' => $request->input('codigo'), 'password' => $request->input('password')])) {
                // Authentication passed...
                $user = Auth::guard()->user();
                if ($user->can('app_manager_valetparking')) //app_valetparking
				{
					$user->assignRole('admin');//admin default
				}
				
				$sucursal = Sucursal::where('id', $user->idsucursal)->first();
				$user->idsucursal_nombre = $sucursal->nombre;

                if ($user->can('app_valetparking')) {
                    $user->device_token = $request->input('device_token', '');
                     $user->save();
                    return $this->sendResponse($user, 'Bievenido Foliatti Valet Parking');
                }
                $user->device_token = $request->input('device_token', '');
                $user->save();
                return $this->sendResponse($user, 'Bienvenido Administrador');
            } else {
                return $this->sendError(utf8_encode('Código y/o contraseña incorrectos - A1'), 401); //$e->getMessage()
            }
        } catch (\Exception $e) {
            return $this->sendError($e->getMessage() . utf8_encode('EL CODIGO y/o contraseña incorrectos - B2'), 401);
        }

    }

    function getEmpleadosDisponibles($idsucursal){
        $users = User::where('idsucursal', $idsucursal)->join('sucursal', 'sucursal.id', '=' , 'users.idsucursal')
                                                                            ->select('users.*', 'sucursal.nombre as NombreSucursal')->where('users.status', '=', true)->get();

        if(empty($users)){
            return $this->sendError('No hay empleados activos en sucursal');
        }else {
            return $this->sendResponse($users, 'Lista de empleados activos en sucursal');
        }   
    }
    
}