<?php

namespace App\Http\Controllers;

use File;
use DateTime;
use DateInterval;
use Carbon\Carbon;
use App\Models\User;
use App\Models\Mesa;
use App\Models\Roles;
use App\Models\Sucursal;
use Illuminate\Support\Str;
use App\Models\MesaSucursal;
use Illuminate\Http\Request;
use App\Models\LayoutEvento;
use App\Models\MesasPosicion;
use Illuminate\Routing\Route;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Authh;
use App\Models\LayoutEventoMesa;
use Illuminate\Support\Facades\DB;
use Spatie\Permission\Models\Role;
use App\Http\Controllers\exception;
use App\Models\LayoutEventoSeccion;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Permission;
use Spatie\Permission\Traits\HasRoles;
use Illuminate\Support\Facades\Storage;
use Yajra\DataTables\Facades\DataTables;
use App\Exceptions\InvalidRequestException;

class LayoutEventosController extends Controller
{
    use HasRoles;
    private $path = 'acomodo_mesas/';

    public function __construct()
    {
        $this->middleware('permission:listar_layout_eventos', ['only' => ['index']]);
        $this->middleware('permission:crear_layout_eventos', ['only' => ['create','store']]);
        $this->middleware('permission:editar_layout_eventos', ['only' => ['edit','update']]);
    }

    public function store(Request $request)
    {
        try
        {
            if(LayoutEvento::whereRaw("nombre ilike '$request->nombre'")->exists())
            {
                throw new \Exception("El nombre ya existe", 1);
            }

            $imagen_mini_name = null;
            $imagen_mini = getB64Image($request->imagen_mini);
            $img_extension = getB64Extension($request->imagen_mini);

            if(!in_array($img_extension, ['jpg', 'jpeg', 'png', 'gif']))
            {
                throw new \Exception("Extensión de imagen mini inválida", 1);
            }

            $imagen_mini_name = 'img_promocion'. time() . '.' . $img_extension;
            $imagen_name = null;

            if($request->imagen != '')
            {
                $imagen = getB64Image($request->imagen);
                $img_extension = getB64Extension($request->imagen);

                if(!in_array($img_extension, ['jpg', 'jpeg', 'png', 'gif']))
                {
                    throw new \Exception("Extensión de imagen inválida", 1);
                }

                $imagen_name = 'img_promocion_mini'. time() . '.' . $img_extension;
            }
            
            DB::beginTransaction();

            $oPromocion = new Promocion();
            $oPromocion->status = $request->status == 'true';
            $oPromocion->tipo = $request->tipo;
            $oPromocion->nombre = $request->nombre;
            $oPromocion->enlace = $request->enlace;
            $oPromocion->updated_by = Auth::id();
            $oPromocion->imagen_mini = $imagen_mini_name;
            $oPromocion->imagen = $imagen_name;
            $oPromocion->hasnotificaciones = $request->hasnotificaciones;
            $oPromocion->beneficio_nivel_id = $request->beneficio_nivel_id;
            $oPromocion->f_lun = $request->f_lun;
            $oPromocion->f_mar = $request->f_mar;
            $oPromocion->f_mie = $request->f_mie;
            $oPromocion->f_jue = $request->f_jue;
            $oPromocion->f_vie = $request->f_vie;
            $oPromocion->f_sab = $request->f_sab;
            $oPromocion->f_dom = $request->f_dom;
            $oPromocion->not_hora = $request->not_hora;
            $oPromocion->not_mensaje = $request->not_mensaje;
            $oPromocion->save();

            //Save with full path
            if($imagen_name != '')
            {
                $img_name_DB = env('APP_FOLIATTI_IMG_PATH') . 'promociones/' . $oPromocion->id . '/' .   $imagen_name;
                $oPromocion->imagen_fullpath = $img_name_DB;            
            }
            
            $img_mini_name_DB = env('APP_FOLIATTI_IMG_PATH') . 'promociones/' . $oPromocion->id . '/' .   $imagen_mini_name;
            $oPromocion->imagen_mini_fullpath = $img_mini_name_DB;            
            
            $oPromocion->save();

            foreach($request->id_sucursal as $idSucursal)
            {
                PromocionSucursal::insert([
                    'idpromocion' => $oPromocion->id,
                    'idsucursal' => $idSucursal
                ]);
            }

            Storage::disk('promocion')->put($oPromocion->id . '/' .$imagen_mini_name, $imagen_mini);

            if($request->imagen != '')
            {
                Storage::disk('promocion')->put($oPromocion->id . '/' .$imagen_name, $imagen);
            }

            DB::commit();
        }catch (\Exception $e)
        {
            throw new InvalidRequestException($e->getMessage().$e->getLine());
        }
    }

    public function update(Request $request, $id)
    {
        try
        {
            if(Promocion::whereRaw("nombre ilike '$request->nombre'")->where('id','<>',$id)->exists())
            {
                throw new \Exception("El nombre ya existe", 1);
            }

            $oPromocion = Promocion::findOrFail($id);
            DB::beginTransaction();

            $oPromocion->status = $request->status == 'true';
            $oPromocion->tipo = 1;
            $oPromocion->nombre = $request->nombre;
            $oPromocion->enlace = $request->enlace;
            $oPromocion->beneficio_nivel_id = 1;//$request->beneficio_nivel_id;
            $oPromocion->hasnotificaciones = $request->hasnotificaciones;
            $oPromocion->f_lun = $request->f_lun;
            $oPromocion->f_mar = $request->f_mar;
            $oPromocion->f_mie = $request->f_mie;
            $oPromocion->f_jue = $request->f_jue;
            $oPromocion->f_vie = $request->f_vie;
            $oPromocion->f_sab = $request->f_sab;
            $oPromocion->f_dom = $request->f_dom;
            $oPromocion->not_hora = $request->not_hora;
            $oPromocion->not_mensaje = $request->not_mensaje;
            $oPromocion->save();

            DB::commit();

            $oPromocion->not_hora = $request->not_hora;
            $oPromocion->not_mensaje = $request->not_mensaje;
            $oPromocion->incompleto = false;
            $oPromocion->updated_by = Auth::id();
            $imagenDelete = [];
            $imagen_name = "";
            $imagen_mini_name = "";

            if($request->imagen_mini != '')
            {
                $imagenDelete[] = $oPromocion->id . '/' .$oPromocion->imagen_mini;
                $imagen_mini = getB64Image($request->imagen_mini);
                $img_extension = getB64Extension($request->imagen_mini);

                if(!in_array($img_extension, ['jpg', 'jpeg', 'png', 'gif']))
                {
                    throw new \Exception("Extensión de imagen mini inválida", 1);
                }

                $imagen_mini_name = 'img_promocion_mini'. time() . '.' . $img_extension;
                $oPromocion->imagen_mini = $imagen_mini_name;
                Storage::disk('promocion')->put($oPromocion->id . '/' .$imagen_mini_name, $imagen_mini);

                //Save with full path
                $img_mini_name_DB = env('APP_FOLIATTI_IMG_PATH') . 'promociones/' . $oPromocion->id . '/' .   $imagen_mini_name;
                $oPromocion->imagen_mini_fullpath = $img_mini_name_DB;
            }

            if($request->imagen_delete != '')
            {
                $imagenDelete[] = $oPromocion->id . '/' .$oPromocion->imagen;
                $oPromocion->imagen = null;
                $oPromocion->imagen_fullpath = null;
            }

            if($request->imagen != '')
            {
                $imagenDelete[] = $oPromocion->id . '/' .$oPromocion->imagen;
                $imagen = getB64Image($request->imagen);
                $img_extension = getB64Extension($request->imagen);

                if(!in_array($img_extension, ['jpg', 'jpeg', 'png', 'gif']))
                {
                    throw new \Exception("Extensión de imagen inválida", 1);
                }

                $imagen_name = 'img_promocion'. time() . '.' . $img_extension;
                $oPromocion->imagen = $imagen_name;
                Storage::disk('promocion')->put($oPromocion->id . '/' .$imagen_name, $imagen);

                //Save with full path
                $img_name_DB = env('APP_FOLIATTI_IMG_PATH') . 'promociones/' . $oPromocion->id . '/' .   $imagen_name;
                $oPromocion->imagen_fullpath = $img_name_DB;
            }
  
            $oPromocion->save();

            if (Auth::user()->can('ver_todas_sucursales'))
            {
                $oPromocion->promocionSucursal()->delete();

                foreach($request->id_sucursal as $idSucursal)
                {
                    PromocionSucursal::insert([
                        'idpromocion' => $oPromocion->id,
                        'idsucursal' => $idSucursal
                    ]);
                }
            }

            Storage::disk('promocion')->delete($imagenDelete);

            DB::commit();

            $fecha_inicio = "2024-01-17";
            $fecha_fin = "2024-12-31";
            $hora_inicio = "00:00:00";
            $hora_fin = "23:59:00";
            
            // Convierte las fechas a objetos DateTime
            $inicio = new DateTime($fecha_inicio);
            $fin = new DateTime($fecha_fin);

            // Verifica si la fecha_inicio es menor que la fecha actual
            $hoy = new DateTime(); // Fecha actual

            if ($inicio < $hoy) 
            {
                $inicio = $hoy;
            }
            
            // Crea un intervalo de 1 día
            $intervalo = new DateInterval('P1D');
            
            // Genera las fechas en el rango
            $fechas = [];
            $fechas_num = [];
            
            $oPromocion->promocionNotificacion()->delete();

            while ($inicio <= $fin)
            {
                $fecha_actual = $inicio->format('Y-m-d');
                $fechas[] = $fecha_actual;
                $fechas_num[] = $inicio->format('N');
                $inicio->add($intervalo);
            }

            // Ahora puedes usar el array $fechas en tu lógica
            $num = 0;
            foreach ($fechas as $fecha)
            {
                $numero = $fechas_num[$num];
                $programarfecha = false;
                switch ($numero) 
                {
                    case 1:                   
                        if($oPromocion->f_lun || ($oPromocion->f_lun==1))
                            $programarfecha = true;
                        break;
                    case 2:
                        if($oPromocion->f_mar)
                            $programarfecha = true;
                        break;
                    case 3:
                        if($oPromocion->f_mie)
                            $programarfecha = true;
                        break;
                    case 4:
                        if($oPromocion->f_jue)
                            $programarfecha = true;
                        break;
                    case 5:
                        if($oPromocion->f_vie)
                            $programarfecha = true;
                        break;
                    case 6:
                        if($oPromocion->f_sab)
                            $programarfecha = true;
                        break;
                    case 7:
                        if($oPromocion->f_dom)
                            $programarfecha = true;
                        break;
                    default:
                        $programarfecha = false;
                }

                if($programarfecha) //Programar fecha
                {
                    $iPromocionNotificacion = new PromocionNotificacion();
                    $iPromocionNotificacion->idpromocion = $oPromocion->id;
                    $iPromocionNotificacion->fecha_notificacion = $fecha . " " . $oPromocion->not_hora;
                    $iPromocionNotificacion->titulo = $oPromocion->nombre;
                    $iPromocionNotificacion->mensaje = $oPromocion->not_mensaje;
                    $iPromocionNotificacion->id_promocion_foliatti = $oPromocion->codigo;

                    // Ejecutar la consulta
                    $resultados = DB::table('promocion_sucursal')
                    ->select('idsucursal')
                    ->where('idpromocion', $oPromocion->id)
                    ->get();

                    // Obtener los valores de 'idsucursal' como una cadena separada por comas
                    $sucursales = $resultados->pluck('idsucursal')->implode(',');
                    $iPromocionNotificacion->sucursales = $sucursales;
                    $iPromocionNotificacion->save();
                }                      

                $num = $num + 1;
                // Aquí puedes realizar otras operaciones con la fecha
            }

            DB::commit();
        } catch (\Exception $e)
        {
            throw new InvalidRequestException($e->getMessage().$e->getLine());
        }
    }

    public function destroy($id)
    {
        $oBeneficio = Promocion::findOrFail($id);
        $oBeneficio->delete();
    }

    //funciones nuevas
    public function index()
    {
        return view('eventos.layout_eventos_list');
    }

    public function datatableeventos(Request $request)
    {
        $usuarioAuth = Auth::user();
        $layouteventos = LayoutEvento::select('id', 'nombre', 'idsucursal', 'espacio', 'sillas', 'created_at', 'status', 'capacidad');

        // Sin permiso solo ve la sucursal que tiene asignada
        if (!$usuarioAuth->can('ver_todas_sucursales'))
        {
            $layouteventos->whereHas('Sucursal', function ($query) use ($usuarioAuth) {
                $query->where('idsucursal', $usuarioAuth->idsucursal);
            });
        }
        $layouteventos = $layouteventos->get();

        return DataTables::of($layouteventos)
        ->addColumn('status', function($layouteventos){
            return ($layouteventos->status) ? "Activo" : "Desactivado";
        })
        ->addColumn('sillas', function($layouteventos){
            if($layouteventos->sillas == "")
            {
                return "Sin imagen";
            }
            else
            {
                return "<img src='".asset($layouteventos->sillas)."' class='img-fluid ver_imagen' style='cursor: pointer;'>";
            }
        })
        ->addColumn('created_at', function($layouteventos){
            $carbon = Carbon::parse($layouteventos->created_at);
            return $formateada1 = $carbon->format('d-m-Y h A');
        })
        ->addColumn('idsucursal', function($layouteventos){
            $sucursales = Sucursal::findorfail($layouteventos->idsucursal);
            return $sucursales->nombre;
        })
        ->addColumn('opciones', function($layouteventos){
            $acciones = '';
            if (Gate::allows('editar_layout_eventos'))
            {
                $acciones .= '<a class="btn btn-warning" href="'.url('/layouteventos/'.$layouteventos->id.'/edit').'">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </a> ';
            }

            if (Gate::allows('eliminar_layout_eventos'))
            {
                $acciones .= '<button class="btn btn-danger btn_eliminar" data-route="'.route('eliminar_eventos', $layouteventos->id).'" id="btnEliminar-'.$layouteventos->id.'"><i class="fa-solid fa-circle-minus"></i></button> ';
            }

            if (Gate::allows('editar_layout_eventos'))
            {
                $acciones .= '<button class="btn btn-warning btn_copiar" data-route="'.route('copiar_eventos', $layouteventos->id).'">
                                    <i class="fa-solid fa-copy"></i>
                                </button>';
            }

            $acciones .= ' <a class="btn btn-primary" href="'.route('acomodo_evento', $layouteventos->id).'">
                            <i class="fa-solid fa-wine-bottle"></i>
                        </a> ';

            return $acciones;
        })
        ->rawColumns(['status','created_at', 'idsucursal', 'sillas', 'opciones'])
        ->toJson();
    }

    public function create(Request $request)
    {
        $usuarioAuth = Auth::user();
        $sucursales = Sucursal::where('status', true)->orderBy('nombre');

        if (!$usuarioAuth->can('ver_todas_sucursales'))
        {
            $sucursales->where('id', $usuarioAuth->sucursal->id);
        }

        $sucursales = $sucursales->get();
        $mesas = Mesa::where('deleted_at', null)->orderBy('nombre');
        $mesas = $mesas->get();

        return view('eventos.layout_eventos_create',[
            'editar' => false,
            'sucursales' => $sucursales,
            'mesas' => $mesas,
        ]);
    }

    public function guardarMesa(Request $request)
    {
        $mesas = MesaSucursal::join('mesa', 'mesa.id', '=', 'mesa_sucursal.idmesa')
            ->join('sucursal', 'sucursal.id', '=', 'mesa_sucursal.idsucursal')
            ->select('mesa.*')
            ->where('mesa_sucursal.idsucursal', $request->id_sucursal)
            ->where('mesa.activo', true)
            ->get();

        $html = view('eventos.catalogoMesaSucursal',[
            'mesas' => $mesas,
        ])->render();

        return response()->json([
            'html' => $html,
        ], 200);
    }

    public function guardarlayaut(Request $request)
    {
        $this->validate($request,[
            'nombrelayoutevento' => 'required|max:100',
            'idSucursal' => 'required|exists:sucursal,id',
            'espacio' => 'required|max:100',
            'flexRadioDefault' => 'required',
            'nombreseccion' => 'required|array|min:1',
        ],
        [
            'nombrelayoutevento.required' => 'El campo nombre es requerido',
            'nombrelayoutevento.max'      => 'El nombre no puede pasar mas de 100 caracteres',
            
            'idSucursal.required' => 'Por favor seleccione una sucursal!!',
            'idSucursal.exists'      => 'La sucursal no es valida',
            
            'espacio.required' => 'El espacio es requerido',
            'espacio.max'      => 'El espacio no puede pasar mas de 100 caracteres',

            'flexRadioDefault.required' => 'Seleccione el estatus del evento',
            'flexRadioDefault.boolean'  => 'Solo se acepta si o no',

            'nombreseccion.required' => 'Alerta: Se necesita los datos de la sección',
            'nombreseccion.array' => 'El campo nombreseccion debe ser un array',
            'nombreseccion.min' => 'Los datos de las secciones no puede estar vacío',
        ]);

        $mesa = LayoutEvento::create([
            'nombre' => $request->nombrelayoutevento,
            'idsucursal' => $request->idSucursal,
            'sillas' => $request->mesa_sillas,
            'status' => $request->flexRadioDefault,
            'espacio' => $request->espacio,
            'capacidad' => $request->cajones,
        ]);

        $nombreseccion = $request->nombreseccion;
        $colorseccion = $request->colorseccion;
        
        for($i=0; $i < count($nombreseccion); $i++)
        {
            LayoutEventoSeccion::create([
                'nombre' => $nombreseccion[$i],
                'codigo' => $nombreseccion[$i],
                'color' => $colorseccion[$i],
                'idlayout_evento' => $mesa['id'],
            ]);
        }

        $id_mesa = $request->id_mesa;
        $cantidad = $request->cantidad;

        for($i=0; $i < count($id_mesa); $i++)
        {
            if($cantidad[$i] != 0 || $cantidad[$i] != "0")
            {
                LayoutEventoMesa::create([
                    'idmesa' => $id_mesa[$i],
                    'mesas' => $cantidad[$i],
                    'idlayout_evento' => $mesa['id'],
                ]);
            }
        }

        return response()->json([
            'mesa'   => '',
            'evento' => route('layouteventos.index'),
            'icon'   => "success",
            'title'  => 'Guardado exitoso!',
            'text'   => 'Se registro el evento correctamente',
        ], 200); 
    }

    public function edit($id)
    {
        $usuarioAuth = Auth::user();
        $sucursales = Sucursal::where('status', true)->orderBy('nombre');
        if (!$usuarioAuth->can('ver_todas_sucursales'))
        {
            $sucursales->where('id', $usuarioAuth->sucursal->id);
        }
        $sucursales = $sucursales->get();
        
        //$mesas = Mesa::where('deleted_at', null)->orderBy('nombre')->get();

        $layout_evento = LayoutEvento::findorfail($id);
        
        $Layout_evento_seccion = LayoutEventoSeccion::where('idlayout_evento', $id)->orderBy('nombre')->get();
        
        $Layout_evento_mesa = LayoutEventoMesa::select('mesa.nombre', 'mesa.sillas','layout_evento_mesa.idmesa','layout_evento_mesa.mesas as cantidad')
        ->join('mesa', 'layout_evento_mesa.idmesa', '=', 'mesa.id')
        ->where('layout_evento_mesa.idlayout_evento', $id)
        ->get();

        $mesas = MesaSucursal::join('mesa', 'mesa.id', '=', 'mesa_sucursal.idmesa')
            ->join('sucursal', 'sucursal.id', '=', 'mesa_sucursal.idsucursal')
            ->select('mesa.*')
            ->where('mesa_sucursal.idsucursal', $layout_evento->idsucursal)
            ->where('mesa.activo', true)
            ->get();

        return view('eventos.layout_eventos_create',[
            'editar' => true,
            'sucursales' => $sucursales,
            'mesas' => $mesas,
            'layout_evento' => $layout_evento,
            'Layout_evento_seccion' => $Layout_evento_seccion,
            'Layout_evento_mesa' => $Layout_evento_mesa,
        ]);
    }

    public function actualizarlayaut(Request $request, $id_evento)
    {
        $this->validate($request,[
            'nombrelayoutevento' => [
                'required',
                'max:100',
            ],
            'idSucursal' => 'required|exists:sucursal,id',
            'espacio' => 'required|max:100',
            'flexRadioDefault' => 'required',
            'nombreseccion' => 'required|array|min:1',
        ],
        [
            'nombrelayoutevento.required' => 'El campo nombre es requerido',
            'nombrelayoutevento.max'      => 'El nombre no puede pasar mas de 100 caracteres',
            
            'idSucursal.required' => 'Por favor seleccione una sucursal!!',
            'idSucursal.exists'      => 'La sucursal no es valida',
            
            'espacio.required' => 'El espacio es requerido',
            'espacio.max'      => 'El espacio no puede pasar mas de 100 caracteres',

            'flexRadioDefault.required' => 'Seleccione el estatus del evento',
            'flexRadioDefault.boolean'  => 'Solo se acepta si o no',

            'nombreseccion.required' => 'Alerta: Se necesita los datos de la sección',
            'nombreseccion.array' => 'El campo nombreseccion debe ser un array',
            'nombreseccion.min' => 'Los datos de las secciones no puede estar vacío',
        ]);

        $layout_evento = LayoutEvento::findorfail($id_evento);
        $layout_evento->nombre = $request->nombrelayoutevento;
        $layout_evento->idsucursal = $request->idSucursal;
        $layout_evento->status = $request->flexRadioDefault;
        $layout_evento->espacio = $request->espacio;
        $layout_evento->capacidad = $request->cajones;
        $layout_evento->save();

        LayoutEventoSeccion::where('idlayout_evento', $id_evento)->delete();
        LayoutEventoMesa::where('idlayout_evento', $id_evento)->delete();

        $nombreseccion = $request->nombreseccion;
        $colorseccion = $request->colorseccion;
        
        for($i=0; $i < count($nombreseccion); $i++)
        {
            LayoutEventoSeccion::create([
                'nombre' => $nombreseccion[$i],
                'codigo' => $nombreseccion[$i],
                'color' => $colorseccion[$i],
                'idlayout_evento' => $id_evento,
            ]);
        }

        $id_mesa = $request->id_mesa;
        $cantidad = $request->cantidad;

        for($i=0; $i < count($id_mesa); $i++)
        {
            if($cantidad[$i] != "" || $cantidad[$i] != "0")
            {
                LayoutEventoMesa::create([
                    'idmesa' => $id_mesa[$i],
                    'mesas' => $cantidad[$i],
                    'idlayout_evento' => $id_evento,
                ]);
            }
        }

        return response()->json([
            'mesa'   => '',
            'evento' => route('layouteventos.index'),
            'icon'   => "success",
            'title'  => 'Guardado exitoso!',
            'text'   => 'Se edito el evento correctamente',
        ], 200); 
    }

    public function eliminareventos($id_evento)
    {
        $evento = LayoutEvento::findOrFail($id_evento);
        File::delete($evento->sillas);
        $evento->delete();

        LayoutEventoSeccion::where('idlayout_evento', $id_evento)->delete();
        LayoutEventoMesa::where('idlayout_evento', $id_evento)->delete();
        MesasPosicion::where('idlayout_evento', $id_evento)->delete();

        return response()->json([
            'icon'   => "success",
            'title'  => 'Eliminado exitoso!',
            'text'   => 'Se elimino el evento correctamente',
            'dtable' => 'dt_eventos',
        ], 200); 
    }

    public function copiareventos($id_evento)
    {
        
    // Encuentra el evento original
    $layoutEvento = LayoutEvento::findOrFail($id_evento);

    // Duplica la fila
    $nuevoLayoutEvento = $layoutEvento->replicate();

    // Duplica la imagen
    $rutaImagenOriginal = public_path($layoutEvento->sillas);
    $extension = pathinfo($rutaImagenOriginal, PATHINFO_EXTENSION);
    $nuevoNombreImagen = Str::random(12) . '.' . $extension;
    $nuevaRutaImagen = public_path('acomodo_mesas/' . $nuevoNombreImagen);

    if (File::exists($rutaImagenOriginal)) {
        File::copy($rutaImagenOriginal, $nuevaRutaImagen);
        // Actualiza el campo 'sillas' en el nuevo registro con la nueva ruta de la imagen
        $nuevoLayoutEvento->sillas = 'acomodo_mesas/' . $nuevoNombreImagen;
    } else {
        // Manejar el caso en que la imagen original no exista
        return response()->json([
            'icon'   => "error",
            'title'  => 'Error',
            'text'   => 'La imagen original no existe.',
        ], 400);
    }

    // Guarda el nuevo registro
    $nuevoLayoutEvento->save();

    // Copia las secciones del evento
    $layoutEventoSecciones = LayoutEventoSeccion::where('idlayout_evento', $id_evento)->get();

    foreach ($layoutEventoSecciones as $layoutEventoSeccion) {
        $nuevaSeccion = $layoutEventoSeccion->replicate();
        $nuevaSeccion->idlayout_evento = $nuevoLayoutEvento->id;
        $nuevaSeccion->save();
    }

    // Copia las mesas del evento
    $layoutEventoMesas = LayoutEventoMesa::where('idlayout_evento', $id_evento)->get();

    foreach ($layoutEventoMesas as $layoutEventoMesa) {
        $nuevaMesa = $layoutEventoMesa->replicate();
        $nuevaMesa->idlayout_evento = $nuevoLayoutEvento->id;
        $nuevaMesa->save();
    }

    // Copia las mesas del evento ya posicionadas
    $mesasPosiciones = MesasPosicion::where('idlayout_evento', $id_evento)->get();

    foreach ($mesasPosiciones as $mesasPosicion) {
        $nuevaPosicion = $mesasPosicion->replicate();
        $nuevaPosicion->idlayout_evento = $nuevoLayoutEvento->id;
        $nuevaPosicion->save();
    }

    return response()->json([
        'icon'   => "success",
        'title'  => 'Guardado exitoso!',
        'text'   => 'Se duplico el evento correctamente',
        'dtable' => 'dt_eventos',
    ], 200);
    }

    public function acomodo($id_layout)
    {
        $layoutEvento = LayoutEvento::findOrFail($id_layout);

        $sucursal = Sucursal::select('nombre')->findOrFail($layoutEvento->idsucursal);

        $Layout_evento_seccion = LayoutEventoSeccion::where('idlayout_evento', $id_layout)->get();

        $cantidad_mesa = LayoutEventoMesa::join('mesa as m', 'm.id', '=', 'layout_evento_mesa.idmesa')
            ->select('m.icono', 'layout_evento_mesa.mesas as cantidad','m.nombre')
            ->where('layout_evento_mesa.idlayout_evento', $id_layout)
            ->where('layout_evento_mesa.mesas', '!=', 0)
            ->get();

        $Layout_evento_mesa = LayoutEventoMesa::join('mesa as m', 'm.id', '=', 'layout_evento_mesa.idmesa')
            ->select('m.id', 'm.nombre', 'm.sillas', 'm.icono', 'layout_evento_mesa.mesas as cantidad','layout_evento_mesa.idlayout_evento')
            ->where('layout_evento_mesa.idlayout_evento', $id_layout)
            ->where('layout_evento_mesa.mesas', '!=', 0)
            ->get();

        $mesasposicionadas = MesasPosicion::select('mesas_posicion.id_mesa', 'mesas_posicion.posicion', 'mesas_posicion.idlayout_evento', 'mesa.nombre as nom_mesa', 'mesa.icono', 'mesa.sillas', 'layout_evento_seccion.id AS id_seccion', 'layout_evento_seccion.nombre as nom_seccion', 'layout_evento_seccion.codigo', 'layout_evento_seccion.color')
        ->join('layout_evento_mesa', 'layout_evento_mesa.idmesa', '=', 'mesas_posicion.id_mesa')
        ->join('mesa', 'mesa.id', '=', 'layout_evento_mesa.idmesa')
        ->join('layout_evento_seccion', 'layout_evento_seccion.id', '=', 'mesas_posicion.id_seccion')
        ->where('mesas_posicion.idlayout_evento', $id_layout)
        ->where('layout_evento_mesa.idlayout_evento', $id_layout)
        ->get();

        return view('eventos.acomodo',[
            'sucursal' => $sucursal,
            'layoutEvento' => $layoutEvento,
            'cantidad_mesa' => $cantidad_mesa,
            'mesasposicionadas' => $mesasposicionadas,
            'Layout_evento_mesa' => $Layout_evento_mesa,
            'Layout_evento_seccion' => $Layout_evento_seccion,
        ]);
    }

    public function guardaracomodo(Request $request)
    {
        $this->validate($request, [
            'mesa_id'             => 'required|array|min:1',
            'mesa_id.*'           => 'required|numeric',
            'mesaposicion'        => 'required|array|min:1',
            'mesaposicion.*'      => 'required|numeric',
            'mesa_layout_evento'  => 'required|array|min:1',
            'mesa_layout_evento.*'=> 'required|numeric',
            'seccion_id'          => 'required|array|min:1',
            'seccion_id.*'        => 'required|numeric',
        ], [
            'mesa_id.required'              => 'No se detecto ninguna mesa posicionada.',
            'mesa_id.array'                 => 'El campo de ID de mesa debe ser enviado como un arreglo.',
            'mesa_id.min'                   => 'Debe haber al menos un ID de mesa.',
            'mesa_id.*.required'            => 'Cada ID de mesa es requerido.',
            'mesa_id.*.numeric'             => 'Cada ID de mesa debe ser numérico.',
            
            'mesaposicion.required'         => 'Es requerido proporcionar la posición de las mesas.',
            'mesaposicion.array'            => 'La posición de las mesas debe ser enviada como un arreglo.',
            'mesaposicion.min'              => 'Debe haber al menos una posición de mesa.',
            'mesaposicion.*.required'       => 'Cada posición de la mesa es requerida.',
            'mesaposicion.*.numeric'        => 'Cada posición de la mesa debe ser numérica.',
            
            'mesa_layout_evento.required'   => 'Es requerido proporcionar el evento de mesa.',
            'mesa_layout_evento.array'      => 'El evento de mesa debe ser enviado como un arreglo.',
            'mesa_layout_evento.min'        => 'Debe haber al menos un evento de mesa.',
            'mesa_layout_evento.*.required' => 'Cada evento de mesa es requerido.',
            'mesa_layout_evento.*.numeric'  => 'Cada evento de mesa debe ser numérico.',
            
            'seccion_id.required'           => 'Asegúrate que todas las mesas tengan asignada una zona antes de guardar.',
            'seccion_id.array'              => 'No se detecto ninguna zona seleccionado.',
            'seccion_id.min'                => 'Debe haber al una mesa con una zona selccionada.',
            'seccion_id.*.required'         => 'Cada ID de sección es requerido.',
            'seccion_id.*.numeric'          => 'Cada ID de sección debe ser numérico.',
        ]);

        $layout_evento = LayoutEvento::findorfail($request->evento_id);
        $layout_evento->publicado = $request->publicado;
        $layout_evento->save();

        // Validación adicional para asegurar que los arreglos tengan la misma longitud
        $mesa_ids = $request->input('mesa_id');
        $mesaposiciones = $request->input('mesaposicion');
        $mesa_layout_eventos = $request->input('mesa_layout_evento');
        $seccion_ids = $request->input('seccion_id');
    
        if (count($mesa_ids) !== count($mesaposiciones) || count($mesa_ids) !== count($mesa_layout_eventos) || count($mesa_ids) !== count($seccion_ids))
        {
            return response()->json([
                'errors' => [
                    'custom_error' => [
                        'Los arreglos de ID de mesa, posición de mesa, evento de mesa y ID de sección deben tener la misma cantidad de elementos.'
                    ]
                ]
            ], 422);
        }
        else
        {
            MesasPosicion::where('idlayout_evento', $mesa_layout_eventos[0])->delete();

            for ($i = 0; $i < count($mesa_ids); $i++)
            {
                MesasPosicion::create([
                    'id_mesa' => $mesa_ids[$i],
                    'posicion' => $mesaposiciones[$i],
                    'id_seccion' => $seccion_ids[$i],
                    'idlayout_evento' => $mesa_layout_eventos[$i],
                ]);
            }

            if (!file_exists($this->path)) {
                File::makeDirectory($this->path, $mode = 0777, true, true);
            }

            $ruta="";

            if ($request->input('imageData'))
            {
                $imageData = $request->input('imageData');
                $file_name = uniqid() . '.png';  // asumiendo que es png, ajusta según sea necesario
                File::put(public_path($this->path) . $file_name, base64_decode(preg_replace('#^data:image/\w+;base64,#i', '', $imageData)));
                $ruta = $this->path . $file_name;
            }

            $layout_evento = LayoutEvento::findorfail($mesa_layout_eventos[0]);

            if (File::exists($layout_evento->sillas))
            {
                File::delete($layout_evento->sillas);
            }

            $layout_evento->sillas = $ruta;
            $layout_evento->save();
        }

        return response()->json([
            'icon'  => "success",
            'title' => "Guardado exitoso!",
            'text'  => "Se registro el orden de la mesa correctamente",
            'lista' => route('layouteventos.index'),
        ], 200);
    }
}