<?php

namespace App\Http\Controllers;
//use App\Models\Roles; se cambio esto 20-04-2022

use App\Exceptions\InvalidRequestException;

use App\Models\Roles;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
//use Spatie\Permission\Contracts\Role;
use Spatie\Permission\Models\Role;

use Spatie\Permission\Models\Permission;
use Spatie\Permission\Traits\HasRoles;

class RolesController extends Controller
{
    //use HasRoles;
    //
    public function __construct()
    {
        $this->middleware('auth');       
       // $this->middleware('permission:app_valetparking', ['only' => ['index']]);
       // $this->middleware('permission:app_manager_valetparking', ['only' => ['index']]);
    }

    public function index()
    {
        //
        $roles = Roles::all();

        return view('Roles.Roles_list', compact('roles'));
    }

    public function create()
    {
        //
        $permisos = Permission::all();

        return view("Roles.Roles_create", compact('permisos'));
    }
    public function store(Request $request)
    {
        $roles = new Roles();
        $roles->name = $request->nombrerol;

        $roles->save();

        $idRol = $roles->id;

        $permisos = json_decode($request->permisos);
        if (count($permisos) > 0) {

            for ($i = 0; $i < count($permisos); $i++) {
                $permisoasignar = $permisos[$i]->nombrepermiso;

                $role = Role::find($idRol);
                $role->givePermissionTo($permisoasignar);
            }
        }

        $roles = Roles::all();

        return view('Roles.Roles_list', compact('roles'));
    }


    public function edit($id)
    {
        //        
        $rol = Roles::findOrFail($id);
        //$permisos = Permission::all(); 


        $sql =  "
        ;with tblpermisos as (
            select * From public.permissions
        ), tblroles as (
            select * from role_has_permissions
            inner join roles on roles.id = role_has_permissions.role_id	
            where roles.id = " . strval($id) . "
        )
        select case when coalesce(tblroles.id,0) > 0 then true else false end as chek  ,tblpermisos.name,tblpermisos.created_at, tblpermisos.fullname, tblpermisos.description From tblpermisos
        left join tblroles on tblpermisos.id = tblroles.permission_id
        ";

        $permisos =  DB::select($sql);


        return view('Roles.Roles_edit', compact('permisos', 'rol'));
    }
    /*Obtener los permisos que tiene asignados el rol*/
    public function obtenerpermisosasignados($id)
    {

        $sql =  "select permissions.name,role_has_permissions.* from  public.role_has_permissions 
        inner join public.permissions on role_has_permissions.permission_id = permissions.id
        where role_id = " . $id;

        $permisosasignados =  DB::select($sql);

        return response(json_encode($permisosasignados), 200)->header('Content-type', 'text/plain');
    }
    /*funcion actualizar roles y permisos*/
    public function actualizarroles(Request $request)
    {
        $rolactualizar = DB::table('roles')
            ->where('id', $request->idrol)
            ->update([
                'name' => $request->nombrerol
            ]);


        $rol = Role::find($request->idrol);
        /*Actualizar los permisos para el rol*/
        //$request->permisosasignados
        $rol->syncPermissions(json_decode($request->permisosasignados, TRUE));
    }

    public function destroy($id)
    {
        //
        $sql = "select * from public.model_has_roles where role_id =" . strval($id);

        $rolasignado =  DB::select($sql);
        try {

            
            //throw new InvalidRequestException("El rol se encuentra asignado, no es posible eliminarlo, verifique por favor");
            if (count($rolasignado) > 0) {
                throw new InvalidRequestException("El rol se encuentra asignado, no es posible eliminarlo, verifique por favor");
            }

            Role::destroy($id);

            $roles = Roles::all();

            return view('Roles.Roles_list', compact('roles'));
        } catch (\Exception $e) {

            throw new InvalidRequestException($e->getMessage());
        }
    }
}
