<?php

namespace App\Http\Controllers;

use App\Exceptions\InvalidRequestException;
use App\Models\Roles;
use App\Models\Sucursal;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;
use Illuminate\Routing\Route; //18-03-2022
use App\Http\Controllers\exception;
use App\Http\Controllers\Permission;

use Spatie\Permission\Traits\HasRoles;
use Spatie\Permission\Models\Role;
use App\Http\Controllers\Authh;
use Illuminate\Support\Facades\Auth;

use Illuminate\Support\Str;

class Tools 
{


    /**
CallAPI
**/
static public function CallAPI($method, $url, $data = false)
{
    $curl = curl_init();

    switch ($method)
    {
        case "POST":
            curl_setopt($curl, CURLOPT_POST, 1);

            if ($data)
                curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
            break;
        case "PUT":
            curl_setopt($curl, CURLOPT_PUT, 1);
            break;
        default:
            if ($data)
                $url = sprintf("%s?%s", $url, http_build_query($data));
    }

    // Optional Authentication:
    //curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
    //curl_setopt($curl, CURLOPT_USERPWD, "username:password");
	$apiKey = env('APP_FOLIATTIAPI_APIKEY');//"Dev04WtGPWtd6kK6SGCfLKtOWZMZKDy3";

    $headers = array();
    $headers[] = 'apiKey: '.$apiKey;
    $headers[] = 'Accept: application/json';
    $headers[] = 'Content-Type: application/json';
            
/*
	$headers = array
	(
		 'apiKey: '.$apiKey
	);
*/

	curl_setopt($curl, CURLOPT_FOLLOWLOCATION, 1);
	curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
	curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
    curl_setopt($curl, CURLOPT_URL, $url);

	$result = curl_exec($curl);

    curl_close($curl);

    return $result;
}

public static function generateUUID()
{
    // Obtener el timestamp actual en milisegundos
    $timestamp = microtime(true) * 1000;
    
    // Convertir el timestamp a una cadena hexadecimal
    $timestampHex = dechex($timestamp);

    // Obtener una cadena alfanumérica aleatoria
    $randomString = Str::random(32 - strlen($timestampHex));

    // Concatenar el timestamp hexadecimal y la cadena aleatoria
    $uuid = strtoupper($timestampHex . $randomString);

    // Asegurarse de que el UUID tiene exactamente 32 caracteres
    return substr($uuid, 0, 32);
}

}
