<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Sucursal;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use App\Models\Vehiculo;
use \Datetime;
use Illuminate\Support\Facades\Auth;

class iTicketController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('permission:reporte_iticket', ['only' => ['index']]);
    }

    //
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //        
        //obtener combo de las sucursales
        $id = Auth::id();

        $usuarioAuth = User::find($id);
        $users = User::permission('ver_todas_sucursales')->get();
        $rolAsignado = $usuarioAuth->roles()->first()->name;
        $tienePermiso = $usuarioAuth->hasPermissionTo('ver_todas_sucursales');

        if ($tienePermiso > 0) {
            $sucursales = Sucursal::all();
            $usuarios = User::all();
        } else {
            $sucursales = DB::table('sucursal')
                ->select('sucursal.*')
                ->where('sucursal.id', '=', $usuarioAuth->idsucursal)
                ->get();
            /*Colaboradores*/
            $usuarios = DB::table('users')
                ->select('users.*')
                ->where('users.idsucursal', '=', $usuarioAuth->idsucursal)
                ->get();
        }
        //$sucursales = Sucursal::all();




        return view('Reportes.iTicket', compact('sucursales'), compact('usuarios'));
    }



    public function verDatos(Request $request)
    {

        //$nombre  =  $request->nombre;

        $idSucursal = $request->idSucursal;
        $fechaInicio = $request->fechaInicio;
        $fechaFinal = $request->fechaFinal;
        $status = $request->status;
        $idValet = $request->idValet;
        $placas = $request->placas;
        $estatusreclamo = $request->statusreclamo;



        /*Revisar los permisos */
        $id = Auth::id();

        $usuarioAuth = User::find($id);
        $users = User::permission('ver_todas_sucursales')->get();
        $tienePermiso = $usuarioAuth->hasPermissionTo('ver_todas_sucursales');

        if ($tienePermiso > 0) {
            $sql = 'select sucursal.nombre, iticket.id  as idticket,iticket.created_at as fecha, placas,reclamo.id as idreclamo,statusvehiculo.nombre as descestatus, vehiculos.id as idvehiculo,iticket.idstatusvehiculo,iticket.calificacion  from iticket ' .
                'inner join sucursal on sucursal.id = iticket.idsucursal ' .
                'inner join vehiculos on iticket.idvehiculo = vehiculos.id ' .
                'inner join statusvehiculo on statusvehiculo.id = iticket.idstatusvehiculo ' .
                'left join reclamo on iticket.id = reclamo.idticket ' .
                ' WHERE iticket.idsucursal = CASE ' . $idSucursal . ' WHEN -99 THEN iticket.idsucursal ELSE ' . $idSucursal . ' END ';
        } else {


            $sql = 'select sucursal.nombre, iticket.id  as idticket,iticket.created_at as fecha, placas,reclamo.id as idreclamo,statusvehiculo.nombre as descestatus, vehiculos.id as idvehiculo,iticket.idstatusvehiculo,iticket.calificacion  from iticket ' .
                'inner join sucursal on sucursal.id = iticket.idsucursal ' .
                'inner join vehiculos on iticket.idvehiculo = vehiculos.id ' .
                'inner join statusvehiculo on statusvehiculo.id = iticket.idstatusvehiculo ' .
                'left join reclamo on iticket.id = reclamo.idticket ' .
                ' WHERE iticket.idsucursal =  ' .  $usuarioAuth->idsucursal;
        }






        if (!empty($fechaInicio)) {
            $sql = $sql . ' and iticket.created_at >=  \'' . $fechaInicio . '\'';
        }
        if (!empty($fechaFinal)) {
            $sql = $sql .  ' and iticket.created_at <=  \'' . $fechaFinal . ' 23:59:59\'';
        }
        if (!empty($placas)) {
            $sql = $sql . ' and placas like \'%' . $placas . '%\'';
        }

        if ($estatusreclamo == 1) { /*Con reclamo*/
            $sql = $sql . ' and reclamo.id > 0';
        }
        if ($estatusreclamo == 0) { /*Sin reclamo*/
            $sql = $sql . ' and reclamo.id is null';
        }
        if ($status > 0) {
            $sql = $sql . ' and iticket.idstatusvehiculo = ' . $status;
        }

        $reporte = DB::select($sql);

        return response(json_encode($reporte), 200)->header('Content-type', 'text/plain');
    }

    public function getVehiculo($idvehiculo)
    {
        /*$vehiculo = Vehiculo::where('vehiculos.id', $idvehiculo)
            ->leftjoin('marca', 'marca.id', '=', 'vehiculos.idmarca')
            ->leftjoin('linea', 'linea.id', '=', 'vehiculos.idlinea')
            ->leftjoin('color', 'color.id', '=', 'vehiculos.idcolor')
            ->select('vehiculos.*', 'marca.nombre as NombreMarca', 'linea.nombre as NombreLinea', 'color.nombre as NombreColor')->get();*/

        $sql = "select vehiculos.*,iticket.objetosvalor,marca.nombre as nombremarca, linea.nombre as nombrelinea, color.nombre as nombrecolor
            ,img_1,img_2,img_3,img_4,img_5,img_6
             from iticket
            inner join vehiculos on iticket.idvehiculo = vehiculos.id
            left join marca on vehiculos.idmarca = marca.id
            left join linea on linea.id = vehiculos.idlinea
            left join color on color.id = vehiculos.idcolor
            where iticket.id = " . $idvehiculo;

        $vehiculo = DB::select($sql);

        return response(json_encode($vehiculo), 200)->header('Content-type', 'text/plain');

        /*if (empty($vehiculo)) {
            return $this->sendError('Vehiculo no encontrado');
        }else {
            return $this->sendResponse($vehiculo, 'Vehiculo encontrado');
        }*/
    }

    public function verTicket($id)
    {



        $sql = 'select statusvehiculo.nombre as status,
        users.nombre as empleado,
        estacionamientocajon.nombre as estacionamiento,
        iticket_valet.created_at as fecha,
        iticket_valet.detalles,
		iticket.comentarios
        from iticket_valet 
		inner join iticket on iditicket = iticket.id
        left join statusvehiculo on statusvehiculo.id = iticket_valet.idstatusvehiculo
        left join users on users.id = iticket_valet.idempleado
        left join estacionamientocajon on estacionamientocajon.id = iticket_valet.idestacionamientocajon
        where iditicket=' . $id . ' order by iticket_valet.id desc';



        $reporte = DB::select($sql);

        return response(json_encode($reporte), 200)->header('Content-type', 'text/plain');
    }

    public function verReclamo($id)
    {



        $sql = 'select clientes.nombre as nombrecliente,clientes.celular,users.nombre nombreempleado,users.codigo,
        reclamo.created_at,reclamo.comentarios
        from reclamo	
        inner join clientes on clientes.id = reclamo.idcliente
        inner join users on users.id = reclamo.idempleado
        where reclamo.id=' . $id;



        $reporte = DB::select($sql);

        return response(json_encode($reporte), 200)->header('Content-type', 'text/plain');
    }


    public function actualizarEstatusTicket($id)
    {

        DB::table('iticket')
            ->where('id', $id)
            ->update([
                'idstatusvehiculo' => '10',
                'activo' => 'false'

            ]);

        $now = new DateTime();

        DB::table('iticket_valet')->insert(array(
            'iditicket' => $id,
            'idstatusvehiculo' => 10,
            'fecha_asignacion' => $now->format('Y-m-d H:i:s'),
            'created_at' => $now->format('Y-m-d H:i:s'),
            'updated_at' => $now->format('Y-m-d H:i:s')

        ));
    }
}
