<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Beneficio extends Model
{
    use SoftDeletes;

    public $table = 'beneficio';

    public $fillable = [
        'id',
        'idbeneficio_nivel',
        'nombre',
        'descripcion',
        'codigo',
        'status',
        'imagen',
        'imagen_fullpath',
    ];

    protected $casts = [
        'id' => 'int',
        'idbeneficio_nivel' => 'int',
        'nombre' => 'string',
        'descripcion' => 'string',
        'codigo' => 'string',
        'status' => 'boolean',
        'imagen' => 'string',
        'imagen_fullpath' => 'string',
    ];

    public function nivel()
    {
        return $this->belongsTo(BeneficioNivel::class, 'idbeneficio_nivel');
    }

    public function getEstadoAttribute(){
        return $this->status ? 'Activo' : 'Inactivo';
    }
}
