<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEstacionamientocajonTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('estacionamientocajon', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('idestacionamiento')->nullable()->unsigned();
            $table->string('nombre', 100)->nullable();
            $table->string('codigo', 50)->nullable();
            $table->boolean('activo')->nullable();
            $table->boolean('disponible')->nullable();
            $table->timestamps();
            $table->softDeletes();
            $table->foreign('idestacionamiento')->references('id')->on('estacionamiento')->onDelete('cascade')->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('estacionamientocajon');
    }
}
