<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVehiculoValetTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('vehiculo_valet', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('idvehiculo')->unsigned();
            $table->integer('idempleado')->unsigned();
            $table->integer('idcliente')->unsigned();
            $table->integer('idestacionamientocajon')->unsigned()->nullable();
            $table->text('detalles')->nullable();
            $table->dateTime('fecha_asignacion')->nullable();
            $table->dateTime('fecha_inicio')->nullable();
            $table->dateTime('fecha_fin')->nullable();
            $table->boolean('actividad')->nullable();
            $table->timestamps();
            $table->foreign('idvehiculo')->references('id')->on('vehiculos')->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('idempleado')->references('id')->on('users')->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('idcliente')->references('id')->on('clientes')->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('idestacionamientocajon')->references('id')->on('estacionamientocajon')->onDelete('cascade')->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('vehiculo_valet');
    }
}

