@extends('layout')

@section('content')
<script>
	var aArticuloPromocional = {!! @$aArticuloPromocional ? json_encode($aArticuloPromocional) : '[]' !!};
	var tblDatos;

    $(document).ready(function() {
        const Toast = Swal.mixin({
            toast: true,
            position: 'top-end',
            showConfirmButton: false,
            timer: 3000,
            timerProgressBar: true,
            didOpen: (toast) => {
                toast.addEventListener('mouseenter', Swal.stopTimer)
                toast.addEventListener('mouseleave', Swal.resumeTimer)
            }
        });

		const Loaging = Swal.mixin({
            width: '200px',
			allowOutsideClick: false,
			showConfirmButton: false,
			html: 'Cargando...',
			didOpen: () => {
    			Swal.showLoading()
			}
        });

        tblDatos = $('#tblDatos').DataTable({
			// data: aArticuloPromocional,
			columns: [
				{data: 'nombre'},
				{data: 'codigo'},
				{data: 'descripcion'},
				{data: 'valor'},
				{data: 'borrar'}
			],
			ordering: true,
			sSearch: '<span class="kt-input-icon__icon kt-input-icon__icon--left"><span>&ensp;<i class="la la-search"></i></span>&ensp;Buscar</span >',
			language: {
				sProcessing: "Procesando...",
				sLengthMenu: "Mostrar _MENU_ registros",
				sZeroRecords: "No se encontraron resultados",
				sEmptyTable: "Ningún dato disponible en esta tabla",
				sInfo: "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
				sInfoEmpty: "Mostrando registros del 0 al 0 de un total de 0 registros",
				sInfoFiltered: "(filtrado de un total de _MAX_ registros)",
				sInfoPostFix: "",
				sSearch: "Buscar:",
				sUrl: "",
				sInfoThousands: ",",
				sLoadingRecords: "Cargando...",

				oPaginate: {
					sFirst: "Primero",
					sLast: "Último",
					sNext: "Siguiente",
					sPrevious: "Anterior",
				},
			},
			dom: 'lBfrtip',
			buttons: [
				'copyHtml5', 'excelHtml5', 'pdfHtml5', 'csvHtml5'
			]
		});

        $(document).on('click', '[id^="borrar"]', function(e) {
			var index = $(this).data('index');
			aArticuloPromocional.splice(index, 1);
			updateDataTable();
        });

        //Guardar datos
        $("#guardar").on('click', function() {
            let idCategoria = $("#id_categoria:checked").val();
            let nombre = $("#nombre").val();
            let idSucursalChecked = $('[name="id_sucursal[]"]:checked');
			let inicioFecha = $("#inicio_fecha").val();
			let inicioHora = $("#inicio_hora").val();
			let finFecha = $("#fin_fecha").val();
			let finHora = $("#fin_hora").val();
            let status = $('[name=status]:checked').val();

			let idSucursal = [];

			idSucursalChecked.each(function(e){
				idSucursal.push($(this).val());
			});

			let error = false;

			if(idCategoria == null){
				$("#validarCategoria").show();
				error = true;
			}else{
				$("#validarCategoria").hide();
			}

			if(nombre.replace(/ /g) == ''){
				$("#validarNombre").show();
				error = true;
			}else{
				$("#validarNombre").hide();
			}

            if (idSucursal.length == 0) {
                $("#validarSucursal").show();
				error = true;
            } else {
                $("#validarSucursal").hide();
            }

			if (inicioFecha == '') {
                $("#validarInicioFecha").show();
				error = true;
            } else {
                $("#validarInicioFecha").hide();
            }

			if (inicioHora == '') {
                $("#validarInicioHora").show();
				error = true;
            } else {
                $("#validarInicioHora").hide();
            }

			if (finFecha == '') {
                $("#validarFinFecha").show();
				error = true;
            } else {
                $("#validarFinFecha").hide();
            }

			if (finHora == '') {
                $("#validarFinHora").show();
				error = true;
            } else {
                $("#validarFinHora").hide();
            }

			console.log('inicioFecha: ' + inicioFecha);
			console.log('inicioHora: ' + inicioHora);
			if(false)//new Date(inicioFecha + ' ' + inicioHora) < new Date())
			{
				Toast.fire({
					icon: 'error',
					title: 'La fecha y hora fin debe ser mayor a fecha y hora actual'
				});
				return;
			}

			if(new Date(inicioFecha + ' ' + inicioHora) >= new Date(finFecha + ' ' + finHora)){
				Toast.fire({
					icon: 'error',
					title: 'La fecha y hora fin debe ser mayor a fecha y hora inicio'
				});
				return;
			}
			
			if(aArticuloPromocional.length == 0){
				Toast.fire({
					icon: 'error',
					title: 'Debe agregar al menos un artículo promocional'
				});
				return;
			}

			if(error){
				return;
			}

			Loaging.fire();
			
            $.ajax({
                url: "{{ url('recompensas'.(@$recompensa ? '/'.$recompensa->id : '')) }}",
                type: "{{ @$recompensa ? 'PUT' : 'POST' }}",
                data: {
					id_categoria: idCategoria,
                    nombre: nombre,
					id_sucursal: idSucursal,
                    inicio_fecha: inicioFecha,
					inicio_hora: inicioHora,
					fin_fecha: finFecha,
					fin_hora: finHora,
                    status: status,
					articulo_promocional: aArticuloPromocional,
                    _token: '{{csrf_token()}}',
                },
                success: function(e) {
					$('#guardar').prop('disabled', true);
                    Toast.fire({
                        icon: 'success',
                        title: 'Recompensa guardada con éxito'
                    }).then(() => {
						window.location.href = "{{URL::to('recompensas')}}"
					});
                },
				error: function(e){
					let message = 'Ocurrió un error, vuelva a intentarlo';
					if(e.responseJSON != null && e.responseJSON.msg != null){
						message = e.responseJSON.msg;
					}
					console.log(e);
					Toast.fire({
                        icon: 'error',
                        title: message
                    });
				}

            });

        });

		$('#myModal #imagen').on('change', function(e){
			var allowedExtensions = /(\.jpg|\.jpeg|\.png|\.gif)$/i;
			if(!allowedExtensions.exec($(this).val())){
				Toast.fire({
					icon: 'error',
					title: 'No es un tipo de imagen permitido'
				});
				return;
			}

			var reader = new FileReader();
			reader.readAsDataURL($(this).prop('files')[0]);
			reader.onload = function () {
				$('#myModal #imagen-preview').show().attr('src',reader.result); 
			};
			reader.onerror = function (error) {
				$('#myModal #imagen-preview').hide().attr('src',''); 
			};
		});

        $('#guardar-producto-promocional').on('click', function(e) {
			var modal = $('#myModal');

			let nombre = modal.find('#nombre').val();
			let codigo = modal.find('#codigo').val();
			let valor = modal.find('#valor').val();
			let descripcion = modal.find('#descripcion').val();
			let imagen = modal.find('#imagen-preview').attr('src');

			let error = '';
			if(nombre.replace(/ /g) == ''){
				error = 'El nombre es requerido';
			}else if(!codigo.match(/[0-9a-zA-Z]/)){
				error = 'El código no es correcto';
			}else if(!valor.match(/[0-9]/)){
				error = 'El valor no es correcto';
			}else if(nombre.replace(/ /g) == ''){
				error = 'La descripción es requerida';
			}else if(imagen == ''){
				error = 'Debe cargar una imagen';
			}
			
			if(error != ''){
				Toast.fire({
					icon: 'error',
					title: error
				});
				return;
			}

			aArticuloPromocional.push({
				nombre: nombre,
				codigo: codigo,
				valor: valor,
				descripcion: descripcion,
				imagen: imagen
			});

			modal.modal('hide');
			modal.find('#nombre, #codigo, #valor, #descripcion, #imagen').val('');

			updateDataTable();

			modal.find('#imagen').val('');
			$('#myModal #imagen-preview').hide().attr('src','');
			
        });

		updateDataTable();
    });

	var updateDataTable = function(){
		console.log(aArticuloPromocional);
		for(var i in aArticuloPromocional){
			aArticuloPromocional[i].borrar = '<button id="borrar" data-index="' + i + '" class="btn btn-danger"><i class="fa fa-minus-square" aria-hidden="true"></i></button>'
		}
		tblDatos.clear().rows.add(aArticuloPromocional).draw();
	}
</script>
<style>
    .dataTables_filter {
        display: none;
    }
</style>
</head>
<link data-require="datatables@*" data-semver="1.10.12" rel="stylesheet" href="//cdn.datatables.net/1.10.12/css/jquery.dataTables.min.css" />
<link rel="stylesheet" href="//cdn.datatables.net/rowreorder/1.2.0/css/rowReorder.dataTables.min.css" />
<div class="card card-custom">
    <!--begin::Card header-->
    <div class="card-header card-header-tabs-line nav-tabs-line-3x">
        <!--begin::Toolbar-->
        <div class="card-toolbar">
            <ul class="nav nav-tabs nav-bold nav-tabs-line nav-tabs-line-3x">
                <!--begin::Item-->
                <li class="nav-item mr-3">
                    <a class="nav-link active" data-toggle="tab" href="#kt_user_edit_tab_1">
                        <span class="nav-icon">
                            <span class="svg-icon">
                                <!--begin::Svg Icon | path:assets/media/svg/icons/Design/Layers.svg-->
                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                                    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                        <polygon points="0 0 24 0 24 24 0 24" />
                                        <path d="M12.9336061,16.072447 L19.36,10.9564761 L19.5181585,10.8312381 C20.1676248,10.3169571 20.2772143,9.3735535 19.7629333,8.72408713 C19.6917232,8.63415859 19.6104327,8.55269514 19.5206557,8.48129411 L12.9336854,3.24257445 C12.3871201,2.80788259 11.6128799,2.80788259 11.0663146,3.24257445 L4.47482784,8.48488609 C3.82645598,9.00054628 3.71887192,9.94418071 4.23453211,10.5925526 C4.30500305,10.6811601 4.38527899,10.7615046 4.47382636,10.8320511 L4.63,10.9564761 L11.0659024,16.0730648 C11.6126744,16.5077525 12.3871218,16.5074963 12.9336061,16.072447 Z" fill="#000000" fill-rule="nonzero" />
                                        <path d="M11.0563554,18.6706981 L5.33593024,14.122919 C4.94553994,13.8125559 4.37746707,13.8774308 4.06710397,14.2678211 C4.06471678,14.2708238 4.06234874,14.2738418 4.06,14.2768747 L4.06,14.2768747 C3.75257288,14.6738539 3.82516916,15.244888 4.22214834,15.5523151 C4.22358765,15.5534297 4.2250303,15.55454 4.22647627,15.555646 L11.0872776,20.8031356 C11.6250734,21.2144692 12.371757,21.2145375 12.909628,20.8033023 L19.7677785,15.559828 C20.1693192,15.2528257 20.2459576,14.6784381 19.9389553,14.2768974 C19.9376429,14.2751809 19.9363245,14.2734691 19.935,14.2717619 L19.935,14.2717619 C19.6266937,13.8743807 19.0546209,13.8021712 18.6572397,14.1104775 C18.654352,14.112718 18.6514778,14.1149757 18.6486172,14.1172508 L12.9235044,18.6705218 C12.377022,19.1051477 11.6029199,19.1052208 11.0563554,18.6706981 Z" fill="#000000" opacity="0.3" />
                                    </g>
                                </svg>
                                <!--end::Svg Icon-->
                            </span>
                        </span>
                        <span class="nav-text font-size-lg">Datos Recompensa</span>
                    </a>
                </li>
            </ul>
        </div>
        <!--end::Toolbar-->
    </div>
    <!--end::Card header-->
    <!--begin::Card body-->
    <div class="card-body">
        @if (count($errors) > 0)
        <strong>Whoops!</strong> There were some problems with your input.<br><br>
        <ul>
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
        @endif
        <!--form  id="sucursales_form"-->
        <!--@csrf-->
        <div class="tab-content">
            <!--begin::Tab-->
            <div class="tab-pane show active px-7" id="kt_user_edit_tab_1" role="tabpanel">
                <!--begin::Row-->
                <div class="row">
                    <div class="col-xl-2"></div>
                    <div class="col-xl-7 my-2">
                        <!--begin::Row-->
						<div class="form-group row">
                            <label class="col-md-3 form-label col text-lg-right text-left">Tipo de promoción</label>
                            <div class="col-md-9">
								<div class="row">
									@foreach($categorias as $categoria)
									<div class="col-md-4 col-6">
										<label>
											<input type="radio" id="id_categoria" name="id_categoria" value="{{ $categoria->id }}" {{ @$recompensa->idrecompensa_categoria == $categoria->id ? 'checked' : '' }}> {{ $categoria->nombre}}
										</label>
									</div>
									@endforeach
								</div>
                                <span id="validarCategoria" style="display:none;" class="form-text text-danger">Por favor seleccione un tipo de promoción!!</span>
                            </div>
                        </div>
						<div class="form-group row">
                            <label class="col-form-label col-md-3 text-lg-right text-left">Nombre</label>
                            <div class="col-md-9">
                                <input id="nombre" class="form-control form-control-lg form-control-solid" type="text" value="{{ @$recompensa->nombre  }}" />
                                <span id="validarNombre" style="display:none;" class="form-text text-danger">El campo nombre es requerido</span>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-md-3 form-label col text-lg-right text-left">Sucursal</label>
                            <div class="col-md-9">
								<div class="row">
									@foreach($sucursales as $sucursal)
									@php
										$editarSucursal = @is_null($idSucursalUsuario) || $idSucursalUsuario == $sucursal->id;
									@endphp
									<div class="col-md-4 col-6">
										<label>
											<input type="checkbox" @if($editarSucursal) name="id_sucursal[]" @else disabled @endif value="{{ $sucursal->id }}" {{ @in_array($sucursal->id, $aIdSucursalRecompensa) ? 'checked' : '' }}> {{ $sucursal->nombre}}
										</label>
									</div>
									@endforeach
								</div>
                                <span id="validarSucursal" style="display:none;" class="form-text text-danger">Por favor seleccione una sucursal!!</span>
                            </div>
                        </div>
						<div class="form-group row">
                            <label class="col-form-label col-md-3 text-lg-right text-left">Inicio</label>
                            <div class="col-md-4 col-6">
                                <input id="inicio_fecha" class="form-control form-control-lg form-control-solid" type="date" min="{{ date('Y-m-d') }}" value="{{ @$recompensa->inicio_fecha }}"/>
                                <span id="validarInicioFecha" style="display:none;" class="form-text text-danger">El campo Inicio Fecha es requerido</span>
                            </div>
							<div class="col-md-4 col-6">
                                <input id="inicio_hora" class="form-control form-control-lg form-control-solid" type="time" value="{{ @$recompensa->inicio_hora }}" />
                                <span id="validarInicioHora" style="display:none;" class="form-text text-danger">El campo Inicio Hora es requerido</span>
                            </div>
                        </div>
						<div class="form-group row">
                            <label class="col-form-label col-md-3 text-lg-right text-left">Fin</label>
                            <div class="col-md-4 col-6">
                                <input id="fin_fecha" class="form-control form-control-lg form-control-solid" type="date" min="{{ date('Y-m-d') }}" value="{{ @$recompensa->fin_fecha }}"/>
                                <span id="validarFinFecha" style="display:none;" class="form-text text-danger">El campo Fin Fecha es requerido</span>
                            </div>
							<div class="col-md-4 col-6">
                                <input id="fin_hora" class="form-control form-control-lg form-control-solid" type="time" value="{{ @$recompensa->fin_hora }}" />
                                <span id="validarFinHora" style="display:none;" class="form-text text-danger">El campo Fin Hora es requerido</span>
                            </div>
                        </div>
                       	<!--end::Group-->
                        <!--begin::Group-->
                        <div class="form-group row">
                            <label class="col-form-label col-md-3 text-lg-right text-left">Activo</label>
							<div class="col-md-9">
								<div class="row">
									<div class="col-md-2 col-6">
										<label><input type="radio" name="status" value="true" {{ @$recompensa->status ? 'checked' : '' }}> Sí</label>
									</div>
									<div class="col-md-2 col-6">
										<label><input type="radio" name="status" value="false" {{ !@$recompensa || !@$recompensa->status ? 'checked' : '' }}> No</label>
									</div>
								</div>
							</div>
                        </div>
                        <div class="form-group row">
                            <div class="col-md-3">
                            </div>
                            <div class="col-9">
                                <a id="addCloque" href='javascript:void(0)' data-toggle='modal' data-target='#myModal' class="btn btn-success">Agregar artículo promocional <i class="fa-solid fa-plus"></i></a>
                            </div>
                        </div>
                        <br>
                        <div class="form-group row" class="card-body">
                            <div class="col-12">
                                <table class="table border" id="tblDatos">
                                    <thead>
                                        <tr>
                                            <th>Nombre</th>
                                            <th>Código</th>
											<th>Descripción</th>
                                            <th>Valor</th>
                                            <th>Borrar</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
						<div class="form-group row">
							<div class="col-12 text-center">
								<button type="button" id="guardar" class="btn btn-success">Guardar</button>
								<a class="btn btn-danger" href="{{ route('recompensas.index') }}">Cancelar</a>
							</div>
						</div>
                    </div>
                </div>
                <!--end::Row-->
            </div>
            <!--end::Tab-->
        </div>
        <!--/form-->
    </div>
    <!--begin::Card body-->
</div>
@include('Recompensas.articulo_promocional')
@endsection