@extends('layout')

@section('content')
<script>
    var x = new Boolean(true);
    $(document).ready(function() {
        const Toast = Swal.mixin({
            toast: true,
            position: 'top-end',
            showConfirmButton: false,
            timer: 3000,
            timerProgressBar: true,
            didOpen: (toast) => {
                toast.addEventListener('mouseenter', Swal.stopTimer)
                toast.addEventListener('mouseleave', Swal.resumeTimer)
            }
        })

        /*var selectedRowIds = [];
        $('#guardar').click(function() {
            $('#tblPermisos tbody tr:has(input:checkbox:checked)').each(function() {
                //Collecting the row values of the checked rows in an array.
                selectedRowIds.push($(this).val());
            });
            alert(tblPermisos.length() );
        });*/

        var table = $('#tblPermisos').DataTable({
            //autoWidth: true,
            'columnDefs': [{
                'targets': 0,
                'searchable': false,
                'orderable': false,
                'className': 'dt-body-center',
                'render': function(data, type, full, meta) {
                    return '<input type="checkbox" name="id[]" value="' + $('<div/>').text(data).html() + '">';
                }
            }],
            'order': [
                [1, 'asc']
            ],
            destroy: true,
            ordering: true,          
            lengthMenu: [
                [-1],
                ["All"]
            ],
            sSearch: '<span class="kt-input-icon__icon kt-input-icon__icon--left"><span>&ensp;<i class="la la-search"></i></span>&ensp;Buscar</span >',
            language: {
                sProcessing: "Procesando...",
                sLengthMenu: "Mostrar _MENU_ registros",
                sZeroRecords: "No se encontraron resultados",
                sEmptyTable: "Ningún dato disponible en esta tabla",
                sInfo: "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
                sInfoEmpty: "Mostrando registros del 0 al 0 de un total de 0 registros",
                sInfoFiltered: "(filtrado de un total de _MAX_ registros)",
                sInfoPostFix: "",
                sSearch: "Buscar:",
                sUrl: "",
                sInfoThousands: ",",
                sLoadingRecords: "Cargando...",
                oPaginate: {
                    sFirst: "Primero",
                    sLast: "Último",
                    sNext: "Siguiente",
                    sPrevious: "Anterior",
                },
            },
        }).draw();


        $('#example-select-all').on('click', function() {
            // Get all rows with search applied
            var rows = table.rows({
                'search': 'applied'
            }).nodes();
            // Check/uncheck checkboxes for all rows in the table
            $('input[type="checkbox"]', rows).prop('checked', this.checked);
        });


        $('#guardar').on('click', function() {

            var enviarpermisos = [];

            var permisosasignados = [];
            var i = 0;

            $("#tblPermisos tbody tr").each(function() {
                var isChecked

                isChecked = $(this).find('input').prop('checked');

                if (isChecked == true) {

                    permisosasignados[i] = $(this).find('td').eq(1).text();
                }

                i = i + 1;

            });

            /*LLAMADA AXAX*/
            $.ajax({
                url: "{{url('roles/actualizarroles')}}",
                type: 'POST',
                data: {
                    "idrol": $("#idRol").val(),
                    "nombrerol": $("#nombrerol").val(),
                    "permisosasignados": JSON.stringify(permisosasignados),
                    "_token": '{{csrf_token()}}',
                },
                success: function(e) {
                    Toast.fire({
                        icon: 'success',
                        title: 'Rol guardado con éxito!'
                    })

                    window.location.href = "{{URL::to('roles')}}"
                },


            });

        });


    });
</script>
<div class="card card-custom">
    <!--begin::Card header-->
    <div class="card-header card-header-tabs-line nav-tabs-line-3x">
        <!--begin::Toolbar-->
        <div class="card-toolbar">
            <ul class="nav nav-tabs nav-bold nav-tabs-line nav-tabs-line-3x">
                <!--begin::Item-->
                <li class="nav-item mr-3">
                    <a class="nav-link active" data-toggle="tab" href="#kt_user_edit_tab_1">
                        <span class="nav-icon">
                            <span class="svg-icon">
                                <!--begin::Svg Icon | path:assets/media/svg/icons/Design/Layers.svg-->
                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                                    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                        <polygon points="0 0 24 0 24 24 0 24" />
                                        <path d="M12.9336061,16.072447 L19.36,10.9564761 L19.5181585,10.8312381 C20.1676248,10.3169571 20.2772143,9.3735535 19.7629333,8.72408713 C19.6917232,8.63415859 19.6104327,8.55269514 19.5206557,8.48129411 L12.9336854,3.24257445 C12.3871201,2.80788259 11.6128799,2.80788259 11.0663146,3.24257445 L4.47482784,8.48488609 C3.82645598,9.00054628 3.71887192,9.94418071 4.23453211,10.5925526 C4.30500305,10.6811601 4.38527899,10.7615046 4.47382636,10.8320511 L4.63,10.9564761 L11.0659024,16.0730648 C11.6126744,16.5077525 12.3871218,16.5074963 12.9336061,16.072447 Z" fill="#000000" fill-rule="nonzero" />
                                        <path d="M11.0563554,18.6706981 L5.33593024,14.122919 C4.94553994,13.8125559 4.37746707,13.8774308 4.06710397,14.2678211 C4.06471678,14.2708238 4.06234874,14.2738418 4.06,14.2768747 L4.06,14.2768747 C3.75257288,14.6738539 3.82516916,15.244888 4.22214834,15.5523151 C4.22358765,15.5534297 4.2250303,15.55454 4.22647627,15.555646 L11.0872776,20.8031356 C11.6250734,21.2144692 12.371757,21.2145375 12.909628,20.8033023 L19.7677785,15.559828 C20.1693192,15.2528257 20.2459576,14.6784381 19.9389553,14.2768974 C19.9376429,14.2751809 19.9363245,14.2734691 19.935,14.2717619 L19.935,14.2717619 C19.6266937,13.8743807 19.0546209,13.8021712 18.6572397,14.1104775 C18.654352,14.112718 18.6514778,14.1149757 18.6486172,14.1172508 L12.9235044,18.6705218 C12.377022,19.1051477 11.6029199,19.1052208 11.0563554,18.6706981 Z" fill="#000000" opacity="0.3" />
                                    </g>
                                </svg>
                                <!--end::Svg Icon-->
                            </span>
                        </span>
                        <span class="nav-text font-size-lg">Datos rol</span>
                    </a>
                </li>

            </ul>
        </div>
        <!--end::Toolbar-->
    </div>
    <!--end::Card header-->
    <!--begin::Card body-->
    <div class="card-body">


        <div class="tab-content">
            <!--begin::Tab-->
            <div class="tab-pane show active px-7" id="kt_user_edit_tab_1" role="tabpanel">
                <!--begin::Row-->
                <div class="row">
                    <div class="col-xl-2"></div>
                    <div class="col-xl-7 my-2">
                        <!--begin::Row-->
                        <div class="row">
                            <label class="col-3"></label>
                            <div class="col-9">
                                <!--h6 class="text-dark font-weight-bold mb-10">Customer Info:</h6-->
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-form-label col-3 text-lg-right text-left">Nombre Rol</label>
                            <div class="col-9">
                                <input name="nombrerol" id="nombrerol" value="{{$rol->name}}" class="form-control form-control-lg form-control-solid" type="text" value="" />
                                <span id="validarNombre" style="display:none;" class="form-text text-danger">El campo nombre es requerido</span>
                            </div>
                        </div>
                        <div class="form-group row">
                            <div class="col-9">
                                <button type="button" id="guardar" class="btn btn-success">Guardar</button>
                                <a class="btn btn-danger" href="{{route('roles.index')}}">
                                    <span>Cancelar</span>
                                </a>

                            </div>
                        </div>
                        <!--end::Group-->
                    </div>
                </div>
                <!--end::Row-->
            </div>
        </div>

        <div>
            <input name="idRol" style="display:none;" id="idRol" type="text" value="{{$rol->id}}" />
            <div class="card-body">
                <table class="table border" id="tblPermisos">
                    <thead>
                        <tr>
                            <th><input type="checkbox" name="select_all" value="1" id="example-select-all"></th>                           
							<th>Key</th>
							<th>Nombre</th>
							<th>Descripción</th>
							<th>fecha</th>

                        </tr>
                    </thead>
                    <tbody>
                        @foreach($permisos as $Permiso)
                        <tr>
                            <td><input type="checkbox" value="{{$Permiso->chek}}" @if($Permiso->chek == 1) checked @endif ></td>
                            <td>{{$Permiso->name}}</td>
							<td>{{$Permiso->fullname}}</td>
							<td>{{$Permiso->description}}</td>
							<td>{{$Permiso->created_at}}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <!--begin::Card body-->
</div>
@endsection