<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

Route::get('/getPromociones/{tipo}', 'API\PromocionAPIController@getPromociones');

/*
Route::group(['middleware'=>'auth:api'], function(){
    Route::get('/getPromociones/{tipo}', 'API\PromocionAPIController@getPromociones');
});
*/

Route::prefix('cliente')->group(function () {
    Route::post('login', 'API\ClienteAPIController@login');
    Route::post('register', 'API\ClienteAPIController@register');

	Route::post('registerWithEmail', 'API\ClienteAPIController@registerWithEmail'); //@@ 01/08/2022 add new method
    Route::get('validarVinculacionCliente/{id}', 'API\ClienteAPIController@validarVinculacionCliente'); //@@ 01/08/2022 add new method

    
    Route::post('actualizarFotoPerfil/{idcliente}', 'API\ClienteAPIController@actualizarFotoPerfil'); //@@ 23/05/2023 add new method
    
    Route::post('updateClienteSucursalFavorita/{id}', 'API\ClienteAPIController@updateClienteSucursalFavorita'); //@@ 01/05/2023 add new method

	Route::get('validarRegistroFoliattiCliente/{id}', 'API\ClienteAPIController@validarRegistroFoliattiCliente'); //@@ 01/08/2022 add new method

	Route::post('actualizarFullCliente/{id}', 'API\ClienteAPIController@actualizarFullCliente'); //@@ 01/08/2022 add new method
	Route::post('actualizarPasswordCliente/{id}', 'API\ClienteAPIController@actualizarPasswordCliente'); //@@ 01/08/2022 add new method


    Route::post('vincularCliente/{id}', 'API\ClienteAPIController@vincularCliente'); //@@ 01/08/2022 add new method

    Route::post('reenviarCodigoSMSCliente/{id}', 'API\ClienteAPIController@reenviarCodigoSMSCliente'); //@@ 01/08/2022 add new method
    Route::post('reenviarCodigoEmailCliente/{id}', 'API\ClienteAPIController@reenviarCodigoEmailCliente'); //@@ 01/08/2022 add new method



	Route::post('registrarClienteFoliatti/{id}', 'API\ClienteAPIController@registrarClienteFoliatti'); //@@ 01/08/2022 add new method



    Route::post('recargaSaldoClienteFoliatti/{id}', 'API\ClienteAPIController@recargaSaldoClienteFoliatti'); //@@ 01/08/2022 add new method
	Route::post('verificarServicioDepositosClienteFoliatti/{id}', 'API\ClienteAPIController@verificarServicioDepositosClienteFoliatti'); //@@ 01/08/2022 add new method
    
    Route::get('getCuentaClienteFoliatti/{id}', 'API\ClienteAPIController@getCuentaClienteFoliatti');
  

    Route::get('validarcliente/{id}', 'API\ClienteAPIController@validarCliente');


    Route::get('getRegistroClienteFoliatti/{id}', 'API\ClienteAPIController@getRegistroClienteFoliatti');

    Route::post('actualizarCliente/{celular}', 'API\ClienteAPIController@actualizarCliente');


Route::get('checkcliente/{id}', 'API\ClienteAPIController@checkCliente');

Route::get('/getClienteSucursales/{id}', 'API\ClienteAPIController@getClienteSucursales');//@@ 01/08/2022 add new method


Route::post('actualizarFirebaseTokenCliente/{id}', 'API\ClienteAPIController@actualizarFirebaseTokenCliente');//@@ 23/01/2023 update token



});

Route::prefix('user')->group(function () {
    Route::post('login', 'API\UserAPIController@login');
});

//// GET ////
Route::get('/getVehiculo/{placas}', 'API\VehiculoAPIController@getVehiculo');
Route::get('/getVehiculoAsignados/{idempleado}', 'API\VehiculoValetAPIController@getVehiculoAsignados');

Route::get('/abrirturno/{idempleado}', 'API\TurnoAPIController@abrirTurno');
Route::get('/cerrarturno/{idempleado}', 'API\TurnoAPIController@cerrarTurno');
Route::get('/getLinea', 'API\LineaAPIController@getLinea');
Route::get('/getMarca', 'API\MarcaAPIController@getMarca');
Route::get('/getColor', 'API\ColorAPIController@getColor');

Route::get('/getSucursales/{idcompany}', 'API\SucursalAPIController@getSucursales');
Route::get('/getSucursalesNoVinculadas/{idcliente}', 'API\SucursalAPIController@getSucursalesNoVinculadas');

Route::get('/getEstacionamientos/{idsucursal}', 'API\EstacionamientoAPIController@getEstacionamiento');
Route::get('/getEstacionamientocajones/{idestacionamiento}', 'API\EstacionamientoCajonAPIController@getEstacionamientocajon');

Route::get('/getEmpleadosDisponibles/{idsucursal}', 'API\UserAPIController@getEmpleadosDisponibles');
Route::get('/getVehiculocliente/{idcliente}', 'API\IticketAPIController@getVehiculocliente');
Route::get('/getVehiculovalet/{idempleado}', 'API\IticketAPIController@getVehiculovalet');
Route::get('/getVehiculosucursal/{idsucursal}', 'API\IticketAPIController@getVehiculosucursal');

Route::get('/getCliente/{telefono}', 'API\ClienteAPIController@getCliente');
Route::get('/getToken/{token}', 'API\IticketAPIController@getToken');

Route::get('/getAllEstacionamientocajon/{idsucursal}', 'API\EstacionamientoCajonAPIController@getAllEstacionamientocajon');


//Catálogos para el registro del cliente
Route::get('/getTiposIdentificacion', 'API\TipoIdentificacionAPIController@getTiposIdentificacion');//@@ 01/08/2022 add new method
Route::get('/getPaises', 'API\PaisAPIController@getPaises');//@@ 01/08/2022 add new method
Route::get('/getEstados', 'API\EstadoAPIController@getEstados');//@@ 01/08/2022 add new method
Route::get('/getMunicipios', 'API\MunicipioAPIController@getMunicipios');//@@ 01/08/2022 add new method

Route::get('/getMunicipiosByidestado/{idestado}', 'API\MunicipioAPIController@getMunicipiosByidestado');//@@ 01/08/2022 add new method
Route::get('/getMunicipioByid/{idmunicipio}', 'API\MunicipioAPIController@getMunicipioByid');//@@ 01/08/2022 add new method



Route::get('/getGeneros', 'API\GeneroAPIController@getGeneros');//@@ 01/08/2022 add new method
Route::get('/getEstadosCiviles', 'API\EstadoCivilAPIController@getEstadosCiviles');//@@ 01/08/2022 add new method

Route::get('/synchronizePaises', 'API\PaisAPIController@synchronizePaises');//@@ 01/08/2022 add new method
Route::get('/synchronizeEstados', 'API\EstadoAPIController@synchronizeEstados');//@@ 01/08/2022 add new method
Route::get('/synchronizeMunicipios', 'API\MunicipioAPIController@synchronizeMunicipios');//@@ 01/08/2022 add new method
Route::get('/synchronizeEstadosCiviles', 'API\EstadoCivilAPIController@synchronizeEstadosCiviles');//@@ 01/08/2022 add new method
Route::get('/synchronizeGeneros', 'API\GeneroAPIController@synchronizeGeneros');//@@ 01/08/2022 add new method
Route::get('/synchronizeTiposIdentificacion', 'API\TipoIdentificacionAPIController@synchronizeTiposIdentificacion');//@@ 01/08/2022 add new method









//// POST ////
Route::post('/registerVehiculo', 'API\VehiculoAPIController@create');
Route::post('/actualizarVehiculo/{idvehiculo}', 'API\VehiculoAPIController@update');
Route::post('/recibirvehiculo', 'API\IticketAPIController@recibirvehiculo');
Route::post('/estacionarvehiculo', 'API\IticketAPIController@estacionarvehiculo');
Route::post('/movervehiculo', 'API\IticketAPIController@movervehiculo');
Route::post('/recolectararticuloReq', 'API\IticketAPIController@recolectararticuloReq');
Route::post('/recolectararticuloValet', 'API\IticketAPIController@recolectararticuloValet');
Route::post('/recolectararticuloValetRes', 'API\IticketAPIController@recolectararticuloValetRes');
Route::post('/solicitarvehiculo', 'API\IticketAPIController@solicitarvehiculo');
Route::post('/solicitarvehiculoValet', 'API\IticketAPIController@solicitarvehiculoValet');
Route::post('/entregarvehiculo', 'API\IticketAPIController@entregarvehiculo');



Route::post('/registrarMarca', 'API\MarcaAPIController@create');
Route::post('/registrarLinea', 'API\LineaAPIController@create');
Route::post('/registrarColor', 'API\ColorAPIController@create');

Route::post('/calificariTicket', 'API\IticketAPIController@calificariTicket');
Route::post('/dejarlistovehiculo', 'API\IticketAPIController@dejarlistovehiculo');
Route::post('/desactivariTicket', 'API\IticketAPIController@desactivariTicket');

Route::post('/registrarReclamo', 'API\ReclamoAPIController@create');

Route::post('/cancelarSolicitud', 'API\IticketAPIController@cancelarSolicitud');


//Beneficios
Route::get('/getBeneficioNiveles', 'API\BeneficioNivelAPIController@getBeneficioNiveles');//@@ 15/03/2022 add new method
Route::get('/getBeneficios/{idbeneficio_nivel}', 'API\BeneficioAPIController@getBeneficios');
Route::get('/getBeneficiosByNivel', 'API\BeneficioAPIController@getBeneficiosByNivel');
Route::get('/getBeneficiosTemp', 'API\BeneficioAPIController@getBeneficiosTemp');



Route::get('/getRecompensas/{idrecompensa_categoria}', 'API\RecompensaAPIController@getRecompensas');
Route::get('/getRecompensaPromocionales/{idrecompensa_categoria}', 'API\RecompensaAPIController@getRecompensaPromocionales');



Route::get('/sendNotificacionesPromociones', 'API\PromocionAPIController@sendNotificacionesPromociones');




Route::get('/eventos_activos', 'API\EventosController@eventos_activos');

Route::post('/enviarNotificacionCliente', 'API\NotificacionesAPIController@enviarNotificacionCliente');
