<?php $__env->startSection('content'); ?>
<script>
	var aArticuloPromocional = <?php echo @$aArticuloPromocional ? json_encode($aArticuloPromocional) : '[]'; ?>;
	var tblDatos;

    $(document).ready(function() {
        const Toast = Swal.mixin({
            toast: true,
            position: 'top-end',
            showConfirmButton: false,
            timer: 3000,
            timerProgressBar: true,
            didOpen: (toast) => {
                toast.addEventListener('mouseenter', Swal.stopTimer)
                toast.addEventListener('mouseleave', Swal.resumeTimer)
            }
        });

		const Loaging = Swal.mixin({
            width: '200px',
			allowOutsideClick: false,
			showConfirmButton: false,
			html: 'Cargando...',
			didOpen: () => {
    			Swal.showLoading()
			}
        });

        //Guardar datos
        $("#guardar").on('click', function() {
            let nombre = $("#nombre").val();
			let descripcion = $("#descripcion").val();
			let codigo = $("#codigo").val();
            let status = $('[name=status]:checked').val();
			let imagen = $('#imagen').val();
            let imagenPreview = $('#imagen-preview').attr('src');

			let error = false;

			if(nombre.replace(/ /g) == ''){
				$("#validarNombre").show();
				error = true;
			}else{
				$("#validarNombre").hide();
			}

			if(descripcion.replace(/ /g) == ''){
				$("#validarDescripcion").show();
				error = true;
			}else{
				$("#validarDescripcion").hide();
			}

			if(!codigo.match(/^[0-9a-zA-Z]+$/)){
				$("#validarCodigo").show();
				error = true;
			}else{
				$("#validarCodigo").hide();
			}

            if (imagenPreview == '') {
                $("#validarImagen").show();
				error = true;
            } else {
                $("#validarImagen").hide();
            }

			if(error){
				return;
			}

			Loaging.fire();
			
            $.ajax({
                url: "<?php echo e(url('beneficios'.(@$beneficio ? '/'.$beneficio->id : ''))); ?>",
                type: "<?php echo e(@$beneficio ? 'PUT' : 'POST'); ?>",
                data: {
					id_nivel: <?php echo e($nivel->id); ?>,
                    nombre: nombre,
					descripcion: descripcion,
					codigo: codigo,
                    status: status,
					imagen: imagen,
                    _token: '<?php echo e(csrf_token()); ?>',
                },
                success: function(e) {
					$('#guardar').prop('disabled', true);
                    Toast.fire({
                        icon: 'success',
                        title: 'Beneficio guardado con éxito'
                    }).then(() => {
						window.location.href = "<?php echo e(URL::to('beneficios')); ?>"
					});
                },
				error: function(e){
					let message = 'Ocurrió un error, vuelva a intentarlo';
					if(e.responseJSON != null && e.responseJSON.msg != null){
						message = e.responseJSON.msg;
					}
					console.log(e);
					Toast.fire({
                        icon: 'error',
                        title: message
                    });
				}
            });

        });

		$('#imagen-file').on('change', function(e){
			var allowedExtensions = /(\.jpg|\.jpeg|\.png|\.gif)$/i;
			if(!allowedExtensions.exec($(this).val())){
				Toast.fire({
					icon: 'error',
					title: 'No es un tipo de imagen permitido'
				});
				return;
			}
			var reader = new FileReader();
			reader.readAsDataURL($(this).prop('files')[0]);
			reader.onload = function () {
				$('#imagen-preview').show().attr('src',reader.result); 
				$('#imagen').val(reader.result);
			};
			reader.onerror = function (error) {
				$('#imagen-preview').hide().attr('src',''); 
				$('#imagen').val('');
			};
		});
    });

</script>
<link data-require="datatables@*" data-semver="1.10.12" rel="stylesheet" href="//cdn.datatables.net/1.10.12/css/jquery.dataTables.min.css" />
<link rel="stylesheet" href="//cdn.datatables.net/rowreorder/1.2.0/css/rowReorder.dataTables.min.css" />
<div class="card card-custom">
    <!--begin::Card header-->
    <div class="card-header card-header-tabs-line nav-tabs-line-3x">
        <!--begin::Toolbar-->
        <div class="card-toolbar">
            <ul class="nav nav-tabs nav-bold nav-tabs-line nav-tabs-line-3x">
                <!--begin::Item-->
                <li class="nav-item mr-3">
                    <a class="nav-link active" data-toggle="tab" href="#kt_user_edit_tab_1">
                        <span class="nav-icon">
                            <span class="svg-icon">
                                <!--begin::Svg Icon | path:assets/media/svg/icons/Design/Layers.svg-->
                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                                    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                        <polygon points="0 0 24 0 24 24 0 24" />
                                        <path d="M12.9336061,16.072447 L19.36,10.9564761 L19.5181585,10.8312381 C20.1676248,10.3169571 20.2772143,9.3735535 19.7629333,8.72408713 C19.6917232,8.63415859 19.6104327,8.55269514 19.5206557,8.48129411 L12.9336854,3.24257445 C12.3871201,2.80788259 11.6128799,2.80788259 11.0663146,3.24257445 L4.47482784,8.48488609 C3.82645598,9.00054628 3.71887192,9.94418071 4.23453211,10.5925526 C4.30500305,10.6811601 4.38527899,10.7615046 4.47382636,10.8320511 L4.63,10.9564761 L11.0659024,16.0730648 C11.6126744,16.5077525 12.3871218,16.5074963 12.9336061,16.072447 Z" fill="#000000" fill-rule="nonzero" />
                                        <path d="M11.0563554,18.6706981 L5.33593024,14.122919 C4.94553994,13.8125559 4.37746707,13.8774308 4.06710397,14.2678211 C4.06471678,14.2708238 4.06234874,14.2738418 4.06,14.2768747 L4.06,14.2768747 C3.75257288,14.6738539 3.82516916,15.244888 4.22214834,15.5523151 C4.22358765,15.5534297 4.2250303,15.55454 4.22647627,15.555646 L11.0872776,20.8031356 C11.6250734,21.2144692 12.371757,21.2145375 12.909628,20.8033023 L19.7677785,15.559828 C20.1693192,15.2528257 20.2459576,14.6784381 19.9389553,14.2768974 C19.9376429,14.2751809 19.9363245,14.2734691 19.935,14.2717619 L19.935,14.2717619 C19.6266937,13.8743807 19.0546209,13.8021712 18.6572397,14.1104775 C18.654352,14.112718 18.6514778,14.1149757 18.6486172,14.1172508 L12.9235044,18.6705218 C12.377022,19.1051477 11.6029199,19.1052208 11.0563554,18.6706981 Z" fill="#000000" opacity="0.3" />
                                    </g>
                                </svg>
                                <!--end::Svg Icon-->
                            </span>
                        </span>
                        <span class="nav-text font-size-lg">Datos Beneficio</span>
                    </a>
                </li>
            </ul>
        </div>
        <!--end::Toolbar-->
    </div>
    <!--end::Card header-->
    <!--begin::Card body-->
    <div class="card-body">
        <?php if(count($errors) > 0): ?>
        <strong>Whoops!</strong> There were some problems with your input.<br><br>
        <ul>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
        <?php endif; ?>
        <!--form  id="sucursales_form"-->
        <!--<?php echo csrf_field(); ?>-->
        <div class="tab-content">
            <!--begin::Tab-->
            <div class="tab-pane show active px-7" id="kt_user_edit_tab_1" role="tabpanel">
                <!--begin::Row-->
                <div class="row">
                    <div class="col-xl-2"></div>
                    <div class="col-xl-7 my-2">
                        <!--begin::Row-->
						<div class="form-group row">
                            <label class="col-form-label col-md-3 text-lg-right text-left">Nivel</label>
                            <div class="col-md-9">
                                <input class="form-control form-control-lg form-control-solid" type="text" disabled value="<?php echo e($nivel->nombre); ?>" />
                            </div>
                        </div>
						<div class="form-group row">
                            <label class="col-form-label col-md-3 text-lg-right text-left">Nombre del beneficio</label>
                            <div class="col-md-9">
                                <input id="nombre" class="form-control form-control-lg form-control-solid" type="text" value="<?php echo e(@$beneficio->nombre); ?>" />
                                <span id="validarNombre" style="display:none;" class="form-text text-danger">El campo nombre es requerido</span>
                            </div>
                        </div>
						<div class="form-group row">
                            <label class="col-form-label col-md-3 text-lg-right text-left">Descripción</label>
                            <div class="col-md-9">
                                <input id="descripcion" class="form-control form-control-lg form-control-solid" type="text" value="<?php echo e(@$beneficio->descripcion); ?>" />
                                <span id="validarDescripcion" style="display:none;" class="form-text text-danger">El campo descripción es requerido</span>
                            </div>
                        </div>
						<div class="form-group row">
                            <label class="col-form-label col-md-3 text-lg-right text-left">Código</label>
                            <div class="col-md-4">
                                <input id="codigo" class="form-control form-control-lg form-control-solid" type="text" value="<?php echo e(@$beneficio->codigo); ?>" />
                                <span id="validarCodigo" style="display:none;" class="form-text text-danger">El campo código es inválido</span>
                            </div>
                        </div>
                       	<!--end::Group-->
                        <!--begin::Group-->
                        <div class="form-group row">
                            <label class="col-form-label col-md-3 text-lg-right text-left">Activo</label>
							<div class="col-md-9">
								<div class="row">
									<div class="col-md-2 col-6">
										<label><input type="radio" name="status" value="true" <?php echo e(@$beneficio->status ? 'checked' : ''); ?>> Sí</label>
									</div>
									<div class="col-md-2 col-6">
										<label><input type="radio" name="status" value="false" <?php echo e(!@$beneficio || !@$beneficio->status ? 'checked' : ''); ?>> No</label>
									</div>
								</div>
							</div>
                        </div>
						<div class="form-group row">
                            <label class="col-form-label col-md-3 text-lg-right text-left">Imagen</label>
							<div class="col-md-9">
								<input id="imagen-file" class="form-control form-control-lg form-control-solid" type="file" accept="image/png, image/gif, image/jpeg, image/jpg"/>
								<input id="imagen" type="hidden"/>
                                <span id="validarImagen" style="display:none;" class="form-text text-danger">El campo imagen es requerido</span>
								<img src="<?php echo e(@$beneficio ? Storage::disk('beneficio')->url($beneficio->id.'/'.$beneficio->imagen) : ''); ?>" id="imagen-preview" style="<?php echo e(!@$beneficio ? 'display: none;' : ''); ?> height: 150px;" class="p-3">
							</div>
                        </div>
                        <br>
						<div class="form-group row">
							<div class="col-12 text-center">
								<button type="button" id="guardar" class="btn btn-success">Guardar</button>
								<a class="btn btn-danger" href="<?php echo e(route('beneficios.index')); ?>">Cancelar</a>
							</div>
						</div>
                    </div>
                </div>
                <!--end::Row-->
            </div>
            <!--end::Tab-->
        </div>
        <!--/form-->
    </div>
    <!--begin::Card body-->
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fyiusr/public_html/qa-foliatti.itiapp.fyi/resources/views/Beneficios/beneficios_create.blade.php ENDPATH**/ ?>