<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
	<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Interfaz de Selección</title>
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <!-- SweetAlert CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@10">
    <style>
        .cuadricula {
            display: grid;
            grid-template-columns: repeat(19, 1fr);
            grid-template-rows: repeat(14, 1fr);
            width: 70vw;
            height: 70vh;
            gap: 1px;
            box-sizing: border-box;
            border: 1px solid #ccc;
        }

        .cuadro {
            border: 1px solid #aaa;
            display: flex;
            justify-content: center;
            align-items: center;
            font-size: calc(0.5vw + 0.5vh);
        }

        .diagram-container {
            position: relative;
            width: 135px;
            height: 116px;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-wrap: wrap;
        }

        .diagram-square {
            width: 50px;
            height: 50px;
            order: 2;
        }

        .diagram-letter {
            position: absolute;
            font-size: 16px;
            font-family: Arial, sans-serif;
            width: 25px;
            text-align: center;
        }

        #diagram-a {
            top: 50%;
            left: 0;
            transform: translateY(-50%);
            order: 1;
        }

        #diagram-b {
            top: 0;
            left: 50%;
            transform: translateX(-50%);
            order: 3;
        }

        #diagram-c {
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            order: 4;
        }

        #diagram-d {
            top: 50%;
            right: 0;
            transform: translateY(-50%);
            order: 5;
        }

    </style>
</head>
<body>
    <script>
        $(document).ready(function() {
            $('#lugares').val('');

            $.ajax({    
                url: '<?php echo e(route("mesas_posicion")); ?>',
                type: "POST",
                data: {
                    _token : $('meta[name="csrf-token"]').attr('content'),
                    "dato" : "<?php echo e($eventos_all['id']); ?>",
                },
                beforeSend: function(){
                    $("#div_mesas").html('<div class="d-flex justify-content-center"><div class="spinner-border" role="status" style="margin-right: 2%;"></div>...Cargando mesas</div>');
                }
            }).done(function (response) {
                $("#nomEvent").html(response.nombrelargo);
                $("#div_mesas").html(response.html);

                console.log(response);
            }).fail(function (response) {
                console.log("fallo");
                console.log(response);
            });

            $('#datosCliente').on('change', function() {
                // Obtener el texto del cliente seleccionado (nombre y apellido)
                var selectedText = $("#datosCliente option:selected").text();
                
                // Obtener el valor del atributo data-telefono del cliente seleccionado
                var telefono = $("#datosCliente option:selected").data('telefono');
                
                // Asignar el texto del nombre al input llamado 'nombre'
                $('#nombre').val(selectedText);
                
                // Asignar el valor de data-telefono al input llamado 'telefono'
                $('#telefono').val(telefono);
            });
        });

        $('body').on('click','#eliminar_asientos', function(e){
            $('#lugares').val('');
        });

        $('body').on('submit','.form_guardar', function(e){
            e.preventDefault();

            if($("#lugaresArray").length > 0)
            {
                formData = new FormData(document.getElementById($(this).attr('id')));
                var url = $(`#${$(this).attr('id')}`).attr('action');

                var lugares = $('#tablaLugares').html();
                var evento = $('#evento option:selected').text();
                var nombre = $('#nombre').val();
                var telefono = $('#telefono').val();

                Swal.fire({
                    icon: "question",
                    html: `<div style="text-align: left; font-size: 16px; color: #333; font-family: Arial, sans-serif;">
                            <p>Estás por <strong>confirmar</strong> los lugares:</p>
                            <p><strong style="color: #2c3e50;">${lugares}</strong>,</p>
                            <p>Del evento:</p>
                            <p><strong style="color: #2c3e50;"><?php echo e($eventos_all['nombrelargo']); ?></strong>,</p>
                            <p>A nombre de:</p>
                            <p><strong style="color: #2c3e50;">${nombre}</strong>,</p>
                            <p>Contacto:</p>
                            <p><strong style="color: #2c3e50;">${telefono}</strong></p>
                            <p><strong>¿Deseas continuar?</strong></p>
                        </div>`,
                    showDenyButton: true,
                    showCancelButton: true,
                    confirmButtonText: "Sí, confirmar",
                    denyButtonText: `No, cancelar`,
                    width: '85%',
                    didOpen: () => {
                        document.querySelector('.swal2-html-container').style.maxHeight = '390px';
                    }
                }).then((result) => {
                    if (result.isConfirmed)
                    {
                        $.ajax({
                            type:'POST',
                            url:url,
                            contentType: false,
                            processData: false,
                            datatype: "JSON",
                            data: formData,
                            beforeSend: function(){
                                $("#btn_guardar").val("Enviando..");
                                $("#btn_guardar").attr("disabled","disabled");
                            }
                        }).done(function (response) {
                            Swal.fire({
                                icon: response.icon,
                                title: response.title,
                                text: response.text,
                            });

                            $(location).attr('href',response.ruta);
                            console.log(response);
                        }).fail(function (response) {
                            console.log("fallo");
                            console.log(response);

                            $(".error").remove();

                            $.each(response.responseJSON.errors, function (index, value) {
                                $("#" + index).after('<span class="error form-text text-danger"><b>'+value+'</b></span>');
                            });
                        });
                    }
                    else if (result.isDenied)
                    {
                        Swal.fire("Se cancelo la reservación", "", "info");
                    }
                });

                $("#btn_guardar").val("Guardar");
                $("#btn_guardar").attr("disabled",false);
            }
            else
            {
                Swal.fire({
                    icon: "warning",
                    title: "Error al realizar la venta",
                    text: "No se pudo realizar la venta por falta de datos a llenar",
                });
            }

        })
    </script>

    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="p-3 mb-2">
                    <form method="POST" action="<?php echo e($editar ? route('actualizar_reservacion', $evento['id']) : route('guardar_reservacion')); ?>" class="form_guardar" id="form_guardar_reservacion" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="form-row">
                            <div class="form-group col-md-12 text-center">
                                <img src="<?php echo e(asset($eventos_all['imagen'])); ?>" alt="Banner del evento" class="img-fluid" style="width: 40%;">
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group col-md-12">
                                <h4><?php echo e($eventos_all['nombrelargo']); ?></h4>
                            </div>
                        </div>
                        <input type="hidden" name="evento" id="evento" value="<?php echo e($eventos_all['id']); ?>">
                        <div class="form-row">
                            <div class="form-group col-md-12">
                                <label for="nombre">Nombre</label>
                                <input type="text" class="form-control" id="nombre" name="nombre" value="<?php echo e($cliente['nombre']); ?> <?php echo e($cliente['apellido']); ?>" readonly>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="telefono">Teléfono</label>
                                <input type="text" class="form-control" id="telefono" name="telefono" value="<?php echo e($cliente['celular']); ?>">
                            </div>
                            <div class="form-group col-md-6">
                                <label for="folio">Folio/Transacción</label>
                                <input type="text" class="form-control" id="folio" name="folio">
                            </div>
                        </div>
                        <input type="hidden" name="lugaresArray" id="lugaresArray" readonly>
                        <div class="form-row">
                            <div class="form-group col-md-12">
                                <div class="col-md-12 mt-3 mb-4" id="div_mesas"></div>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group col-md-12">
                                <label for="tablaLugares">Lugares seleccionados</label>
                                <div class="input-group">
                                    <div class="table-responsive">
                                        <table class="table table-sm" id="tablaLugares">
                                            <thead>
                                                <tr>
                                                    <th>Posición</th>
                                                    <th>Silla</th>
                                                    <th>Costo</th>
                                                    <th></th>
                                                </tr>
                                            </thead>
                                            <tbody></tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>                            
                        </div>
                        <div class="form-row">
                            <div class="col-md-12">
                                <button type="submit" class="btn btn-success"><?php echo e($editar ? "Actualizar" : "Guardar"); ?></button>
                                <a href="<?php echo e(route('lista_reservacion')); ?>" class="btn btn-danger">Cancelar</a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- jQuery and Bootstrap JavaScript -->
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>
</body>
</html><?php /**PATH /home/fyiusr/public_html/qa-foliatti.itiapp.fyi/resources/views/reservaciones/mesas_posiciones.blade.php ENDPATH**/ ?>