<?php $__env->startSection('content'); ?>
<script>
    $(document).ready(function() {
        const Toast = Swal.mixin({
            toast: true,
            position: 'top-end',
            showConfirmButton: false,
            timer: 3000,
            timerProgressBar: true,
            didOpen: (toast) => {
                toast.addEventListener('mouseenter', Swal.stopTimer)
                toast.addEventListener('mouseleave', Swal.resumeTimer)
            }
        });

		const Loaging = Swal.mixin({
            width: '200px',
			allowOutsideClick: false,
			showConfirmButton: false,
			html: 'Cargando...',
			didOpen: () => {
    			Swal.showLoading()
			}
        });

        //Guardar datos
        $("#guardar").on('click', function() {
            let tipo = $("#tipo").val();
            let nombre = $("#nombre").val();
            let idSucursalChecked = $('[name="id_sucursal[]"]:checked');
			let enlace = $("#enlace").val();
            let not_mensaje = $("#not_mensaje").val();

            let beneficio_nivel_id	= $("#beneficio_nivel_id").val();	
            let hasnotificaciones = $('[name=hasnotificaciones]:checked').val();
            let f_lun = $('[name=f_lun]:checked').val();
            let f_mar = $('[name=f_mar]:checked').val();
            let f_mie = $('[name=f_mie]:checked').val();
            let f_jue = $('[name=f_jue]:checked').val();
            let f_vie = $('[name=f_vie]:checked').val();
            let f_sab = $('[name=f_sab]:checked').val();
            let f_dom = $('[name=f_dom]:checked').val();
            let not_hora = $("#not_hora").val();


            
            let conenlace = $("#conenlace").val();
            let status = $('[name=status]:checked').val();
			let imagenMini = $('#imagen-mini').val();
            let imagenMiniPreview = $('#imagen-mini-preview').attr('src');
			let imagenCompletaPreview = $('#imagen-preview').attr('src');
            let imagen = $('#imagen').val();
            let imagenPreview = $('#imagen-preview').attr('src');

			let idSucursal = [];

			idSucursalChecked.each(function(e){
				idSucursal.push($(this).val());
			});

			let error = false;

			/*if(tipo == null){
				$("#validarTipo").show();
				error = true;
			}else{
				$("#validarTipo").hide();
			}*/

			if(nombre.replace(/ /g) == ''){
				$("#validarNombre").show();
				error = true;
			}else{
				$("#validarNombre").hide();
			}

            if (idSucursal.length == 0) {
                $("#validarSucursal").show();
				error = true;
            } else {
                $("#validarSucursal").hide();
            }

            if(document.getElementById("conenlace").checked)
            {
                if (!enlace.match(/^(http(s):\/\/.)[-a-zA-Z0-9@:%._\+~#=]{2,256}\.[a-z]{2,6}\b([-a-zA-Z0-9@:%_\+.~#?&//=]*)$/)) {
                    $("#validarEnlace").show();
                    error = true;
                } else {
                    $("#validarEnlace").hide();
                }
            }
            else
            {
                $("#validarEnlace").hide();
            }

            /*
            if(document.getElementById("conhasnotificaciones").checked)
            {
                if (not_mensaje == "") {
                    $("#validarNotMensaje").show();
                    error = true;
                } else {
                    $("#validarNotMensaje").hide();
                }
            }
            else
            {
                $("#validarNotMensaje").hide();
            }            
            */


			if (imagenMiniPreview == '') {
                $("#validarImagenMini").show();
				error = true;
            } else {
                $("#validarImagenMini").hide();
            }

            if(!(document.getElementById("conenlace").checked))
            {
                if (imagenCompletaPreview == '') {
                    $("#validarImagen").show();
                    error = true;
                } else {
                    $("#validarImagen").hide();
                }
           }



			if(error){
                alert(error);
				return;
			}

			Loaging.fire();
			
            $.ajax({
                url: "<?php echo e(url('promociones'.(@$promocion ? '/'.$promocion->id : ''))); ?>",
                type: "<?php echo e(@$promocion ? 'PUT' : 'POST'); ?>",
                data: {
					tipo: tipo,
                    nombre: nombre,
					id_sucursal: idSucursal,
                    enlace: enlace,
					imagen: imagen,
					imagen_delete: $('#imagen-delete').val(),
					imagen_mini: imagenMini,
                    status: status,
                    beneficio_nivel_id	: beneficio_nivel_id,	
                    hasnotificaciones : hasnotificaciones,
            f_lun : f_lun,
            f_mar : f_mar,
            f_mie : f_mie,
            f_jue : f_jue,
            f_vie : f_vie,
            f_sab : f_sab,
            f_dom : f_dom,
            not_hora : not_hora,
            not_mensaje : not_mensaje,


                    _token: '<?php echo e(csrf_token()); ?>',
                },
                success: function(e) {
					$('#guardar').prop('disabled', true);
                    Toast.fire({
                        icon: 'success',
                        title: 'Promocion guardada con éxito'
                    }).then(() => {
						window.location.href = "<?php echo e(URL::to('promociones')); ?>"
					});
                },
				error: function(e){
					let message = 'Ocurrió un error, vuelva a intentarlo';
					if(e.responseJSON != null && e.responseJSON.msg != null){
						message = e.responseJSON.msg;
					}
					console.log(e);
					Toast.fire({
                        icon: 'error',
                        title: message
                    });
				}

            });

        });

		$('#imagen-file, #imagen-mini-file').on('change', function(e){
			var allowedExtensions = /(\.jpg|\.jpeg|\.png|\.gif)$/i;
			if(!allowedExtensions.exec($(this).val())){
				Toast.fire({
					icon: 'error',
					title: 'No es un tipo de imagen permitido'
				});
				return;
			}
			let previeElement = $(this).parent().find('img');
			let inputElement = $(this).parent().find('input[type=hidden]');
			var reader = new FileReader();
			reader.readAsDataURL($(this).prop('files')[0]);
			reader.onload = function () {
				previeElement.show().attr('src',reader.result); 
				inputElement.val(reader.result);
			};
			reader.onerror = function (error) {
				previeElement.hide().attr('src',''); 
				inputElement.val('');
			};
			$(this).parent().find('[id^=btn-eliminar-imagen]').show();
		});

		$('#btn-eliminar-imagen').on('click', function(){
			$(this).parent().find('img').attr('src', '');
			$(this).parent().find('input[type=hidden]').val('');
			$(this).hide();
			<?php if(@$promocion->imagen): ?>
			$('#imagen-delete').val('1');
			<?php endif; ?>
		});
    });
</script>
<script language="Javascript">
    function checkImagen()
    {
        var conenlaceVer = document.getElementById("conenlace");
        //alert(conenlace.checked);
        var enlaceurl = document.getElementById("enlace");
        var imagencompleta = document.getElementById("imagencompleta");
        if(conenlaceVer.checked)
        {    
            imagencompleta.style.visibility = "hidden";
            enlaceurl.disabled = false;
        }
        else
        {
                imagencompleta.style.visibility = "visible";
                enlaceurl.disabled = true;
                enlaceurl.value = "";
        }
    }
</script>

<link data-require="datatables@*" data-semver="1.10.12" rel="stylesheet" href="//cdn.datatables.net/1.10.12/css/jquery.dataTables.min.css" />
<link rel="stylesheet" href="//cdn.datatables.net/rowreorder/1.2.0/css/rowReorder.dataTables.min.css" />
<div class="card card-custom">
    <!--begin::Card header-->
    <div class="card-header card-header-tabs-line nav-tabs-line-3x">
        <!--begin::Toolbar-->
        <div class="card-toolbar">
            <ul class="nav nav-tabs nav-bold nav-tabs-line nav-tabs-line-3x">
                <!--begin::Item-->
                <li class="nav-item mr-3">
                    <a class="nav-link active" data-toggle="tab" href="#kt_user_edit_tab_1">
                        <span class="nav-icon">
                            <span class="svg-icon">
                                <!--begin::Svg Icon | path:assets/media/svg/icons/Design/Layers.svg-->
                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                                    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                        <polygon points="0 0 24 0 24 24 0 24" />
                                        <path d="M12.9336061,16.072447 L19.36,10.9564761 L19.5181585,10.8312381 C20.1676248,10.3169571 20.2772143,9.3735535 19.7629333,8.72408713 C19.6917232,8.63415859 19.6104327,8.55269514 19.5206557,8.48129411 L12.9336854,3.24257445 C12.3871201,2.80788259 11.6128799,2.80788259 11.0663146,3.24257445 L4.47482784,8.48488609 C3.82645598,9.00054628 3.71887192,9.94418071 4.23453211,10.5925526 C4.30500305,10.6811601 4.38527899,10.7615046 4.47382636,10.8320511 L4.63,10.9564761 L11.0659024,16.0730648 C11.6126744,16.5077525 12.3871218,16.5074963 12.9336061,16.072447 Z" fill="#000000" fill-rule="nonzero" />
                                        <path d="M11.0563554,18.6706981 L5.33593024,14.122919 C4.94553994,13.8125559 4.37746707,13.8774308 4.06710397,14.2678211 C4.06471678,14.2708238 4.06234874,14.2738418 4.06,14.2768747 L4.06,14.2768747 C3.75257288,14.6738539 3.82516916,15.244888 4.22214834,15.5523151 C4.22358765,15.5534297 4.2250303,15.55454 4.22647627,15.555646 L11.0872776,20.8031356 C11.6250734,21.2144692 12.371757,21.2145375 12.909628,20.8033023 L19.7677785,15.559828 C20.1693192,15.2528257 20.2459576,14.6784381 19.9389553,14.2768974 C19.9376429,14.2751809 19.9363245,14.2734691 19.935,14.2717619 L19.935,14.2717619 C19.6266937,13.8743807 19.0546209,13.8021712 18.6572397,14.1104775 C18.654352,14.112718 18.6514778,14.1149757 18.6486172,14.1172508 L12.9235044,18.6705218 C12.377022,19.1051477 11.6029199,19.1052208 11.0563554,18.6706981 Z" fill="#000000" opacity="0.3" />
                                    </g>
                                </svg>
                                <!--end::Svg Icon-->
                            </span>
                        </span>
                        <span class="nav-text font-size-lg">Datos Promoción</span>
                    </a>
                </li>
            </ul>
        </div>
        <!--end::Toolbar-->
    </div>
    <!--end::Card header-->
    <!--begin::Card body-->
    <div class="card-body">
        <?php if(count($errors) > 0): ?>
        <strong>Whoops!</strong> There were some problems with your input.<br><br>
        <ul>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
        <?php endif; ?>
        <!--form  id="sucursales_form"-->
        <!--<?php echo csrf_field(); ?>-->
        <div class="tab-content">
            <!--begin::Tab-->
            <div class="tab-pane show active px-7" id="kt_user_edit_tab_1" role="tabpanel">
                <!--begin::Row-->
                <div class="row">
                    <div class="col-xl-2"></div>
                    <div class="col-xl-7 my-2">
                        <!--begin::Row-->
						<div class="form-group row">
                            <!--<label class="col-md-3 form-label col text-lg-right text-left">Tipo de elemento</label> -->
                            <div class="col-md-9">
								<div class="row">
									<div class="col-md-4 col-6">
										
											<input type="hidden" name="tipo" value="<?php echo e(@$promocion->tipo == 1 ? '1' : '2'); ?>">
										
									</div>
								</div>
                                
                            </div>
                        </div>


						<div class="form-group row">
                            <label class="col-form-label col-md-3 text-lg-right text-left">Nombre</label>
                            <div class="col-md-9">
                                <input id="nombre" class="form-control form-control-lg form-control-solid" type="text" value="<?php echo e(@$promocion->nombre); ?>" />
                                <span id="validarNombre" style="display:none;" class="form-text text-danger">El campo nombre es requerido</span>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-md-3 form-label col text-lg-right text-left">Sucursal</label>
                            <div class="col-md-9">
								<div class="row">
									<?php $__currentLoopData = $sucursales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sucursal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
										$editarSucursal = @is_null($idSucursalUsuario) || $idSucursalUsuario == $sucursal->id;
									?>
									<div class="col-md-4 col-6">
										<label>
											<input type="checkbox" <?php if($editarSucursal): ?> name="id_sucursal[]" <?php else: ?> disabled <?php endif; ?> value="<?php echo e($sucursal->id); ?>" <?php echo e(@in_array($sucursal->id, $aIdSucursalPromocion) ? 'checked' : ''); ?>> <?php echo e($sucursal->nombre); ?>

										</label>
									</div>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</div>
                                <span id="validarSucursal" style="display:none;" class="form-text text-danger">Por favor seleccione una sucursal!!</span>
                            </div>
                        </div>
						<div class="form-group row">
                            <label class="col-form-label col-md-3 text-lg-right text-left"><input type="checkbox" id="conenlace" <?php echo e(@$promocion->enlace != "" ? 'checked' : ''); ?> onclick="checkImagen();"/>Enlace <i>(https://...)</i></label>
                            <div class="col-md-9">
                                <input id="enlace" class="form-control form-control-lg form-control-solid" type="text" value="<?php echo e(@$promocion->enlace); ?>" <?php echo e(@$promocion->enlace != "" ? '' : 'disabled'); ?>/>
                                <span id="validarEnlace" style="display:none;" class="form-text text-danger">El campo enlace no es válido</span>
                            </div>
                        </div>
                       	<!--end::Group-->
                        <!--begin::Group-->
                        <div class="form-group row">
                            <label class="col-form-label col-md-3 text-lg-right text-left">Activo</label>
							<div class="col-md-9">
								<div class="row">
									<div class="col-md-2 col-6">
										<label><input type="radio" name="status" value="true" <?php echo e(@$promocion->status ? 'checked' : ''); ?>> Sí</label>
									</div>
									<div class="col-md-2 col-6">
										<label><input type="radio" name="status" value="false" <?php echo e(!@$promocion || !@$promocion->status ? 'checked' : ''); ?>> No</label>
									</div>
								</div>
							</div>
                        </div>


<!-- Notificaciones BEGIN-->                        
                        <div class="form-group row">
                            <label class="col-form-label col-md-3 text-lg-right text-left">Nivel</label>
							<div class="col-md-9">
								<div class="row">


                                <select id="beneficio_nivel_id" name="beneficio_nivel_id" class="form-control form-control-lg form-control-solid">
                                <option value="-99">Seleccione Nivel de Beneficio</option>
                                <?php $__currentLoopData = $beneficio_niveles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $beneficio_nivel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($beneficio_nivel->id); ?>"><?php echo e($beneficio_nivel->nombre); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>

                              

								</div>
							</div>
                        </div>


<!-- Notificaciones END --> 

						<div class="form-group row">
                            <label class="col-form-label col-md-3 text-lg-right text-left">Imagen mini</label>
							<div class="col-md-9">
								<input id="imagen-mini-file" class="form-control form-control-lg form-control-solid" type="file" accept="image/png, image/gif, image/jpeg, image/jpg"/>
								<input id="imagen-mini" type="hidden"/>
                                <span id="validarImagenMini" style="display:none;" class="form-text text-danger">El campo imagen mini es requerido</span>
								<img src="<?php echo e(@$promocion ? Storage::disk('promocion')->url($promocion->id.'/'.$promocion->imagen_mini) : ''); ?>" id="imagen-mini-preview" style="<?php echo e(!@$promocion ? 'display: none;' : ''); ?> height: 100px;" class="p-3">
							</div>
                        </div>
						<div class="form-group row" id="imagencompleta">
                            <label class="col-form-label col-md-3 text-lg-right text-left">Imagen completa</label>
							<input id="imagen-delete" type="hidden"/>
							<div class="col-md-9">
								<input id="imagen-file" class="form-control form-control-lg form-control-solid" type="file" accept="image/png, image/gif, image/jpeg, image/jpg"/>
								<input id="imagen" type="hidden"/>
                                <span id="validarImagen" style="display:none;" class="form-text text-danger">El campo imagen completa es requerido</span>
								<img src="<?php echo e(@$promocion ? Storage::disk('promocion')->url($promocion->id.'/'.$promocion->imagen) : ''); ?>" id="imagen-preview" style="<?php echo e(!@$promocion->imagen ? 'display: none;' : ''); ?> height: 150px;" class="p-3">
								<button class="btn btn-danger" id="btn-eliminar-imagen" style="<?php echo e(!@$promocion->imagen ? 'display: none;' : ''); ?>"><i class="fa-solid fa-trash"></i></button>
							</div>
                        </div>



<!-- Notificaciones FREQ BEGIN-->                        
                        <div class="form-group row">
                            <label class="col-form-label col-md-3 text-lg-right text-left">Notificaciones Push</label>
							<div class="col-md-9">
								<div class="row">

                                <div class="col-md-2 col-6">
										<label><input type="checkbox" name="hasnotificaciones" id="hasnotificaciones" <?php echo e(@$promocion->hasnotificaciones ? 'checked' : ''); ?>></label>
                                </div>

								</div>
							</div>
                        </div>


                        <div class="form-group row">
                            <label class="col-form-label col-md-3 text-lg-right text-left">Frecuencia</label>
							<div class="col-md-9">
								<div class="row">

                                <div class="col-md-4 col-6">
								    <label>
										<input type="checkbox" name="f_lun" id="f_lun" value="true" <?php echo e(@$promocion->f_lun ? 'checked' : ''); ?>> Lunes
									</label>
								</div>


                                <div class="col-md-4 col-6">
								    <label>
										<input type="checkbox" name="f_mar" id="f_mar" value="true" <?php echo e(@$promocion->f_mar ? 'checked' : ''); ?>> Martes
									</label>
								</div>


                                <div class="col-md-4 col-6">
								    <label>
										<input type="checkbox" name="f_mie" id="f_mie" value="true" <?php echo e(@$promocion->f_mie ? 'checked' : ''); ?>> Miércoles
									</label>
								</div>


                                <div class="col-md-4 col-6">
								    <label>
										<input type="checkbox" name="f_jue" id="f_jue" value="true" <?php echo e(@$promocion->f_jue ? 'checked' : ''); ?>> Jueves
									</label>
								</div>


                                <div class="col-md-4 col-6">
								    <label>
										<input type="checkbox" name="f_vie" id="f_vie" value="true" <?php echo e(@$promocion->f_vie ? 'checked' : ''); ?>> Viernes
									</label>
								</div>


                                <div class="col-md-4 col-6">
								    <label>
										<input type="checkbox" name="f_sab" id="f_sab" value="true" <?php echo e(@$promocion->f_sab ? 'checked' : ''); ?>> Sábado
									</label>
								</div>


                                <div class="col-md-4 col-6">
								    <label>
										<input type="checkbox" name="f_dom" id="f_dom" value="true" <?php echo e(@$promocion->f_dom ? 'checked' : ''); ?>> Domingo
									</label>
								</div>


                                    

								</div>
							</div>
                        </div>



                        <div class="form-group row">
                            <label class="col-form-label col-md-3 text-lg-right text-left">Hora</label>
							<div class="col-md-9">
								<div class="row">

                                <div class="col-md-2 col-6">
										
                                <input type="time" id="not_hora" name="not_hora" min="07:00" max="22:00" required value="<?php echo e(@$promocion->not_hora); ?>"/>                                

                                </div>

								</div>
							</div>
                        </div>



                        <div class="form-group row">
                            <label class="col-form-label col-md-3 text-lg-right text-left">Mensaje (Máx 60 caracteres)</label>
							<div class="col-md-9">
								<div class="row">

                   

                                <input id="not_mensaje" name="not_mensaje" class="form-control form-control-lg form-control-solid" type="text" value="<?php echo e(@$promocion->not_mensaje); ?>"/>
                                <span id="validarNotMensaje" style="display:none;" class="form-text text-danger">El campo Mensaje no es válido</span>


                   

								</div>
							</div>
                        </div>
                        


<!-- Notificaciones FREQ END --> 




                        <br>
						<div class="form-group row">
							<div class="col-12 text-center">
								<button type="button" id="guardar" class="btn btn-success">Guardar</button>
								<a class="btn btn-danger" href="<?php echo e(route('promociones.index')); ?>">Cancelar</a>
							</div>
						</div>
                    </div>
                </div>
                <!--end::Row-->
            </div>
            <!--end::Tab-->
        </div>
        <!--/form-->
    </div>
    <!--begin::Card body-->
</div>

<script language="Javascript">
    checkImagen();                            
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fyiusr/public_html/qa-foliatti.itiapp.fyi/resources/views/Promociones/promociones_create.blade.php ENDPATH**/ ?>