<script>
	$(document).ready(function() {
		$('#tblBeneficios').DataTable({
			destroy: true,
			ordering: true,
			sSearch: '<span class="kt-input-icon__icon kt-input-icon__icon--left"><span>&ensp;<i class="la la-search"></i></span>&ensp;Buscar</span >',
			language: {
				sProcessing: "Procesando...",
				sLengthMenu: "Mostrar _MENU_ registros",
				sZeroRecords: "No se encontraron resultados",
				sEmptyTable: "Ningún dato disponible en esta tabla",
				sInfo: "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
				sInfoEmpty: "Mostrando registros del 0 al 0 de un total de 0 registros",
				sInfoFiltered: "(filtrado de un total de _MAX_ registros)",
				sInfoPostFix: "",
				sSearch: "Buscar:",
				sUrl: "",
				sInfoThousands: ",",
				sLoadingRecords: "Cargando...",
				oPaginate: {
					sFirst: "Primero",
					sLast: "Último",
					sNext: "Siguiente",
					sPrevious: "Anterior",
				},
			},
		}).draw();
	});

	/*FUNCIÓN ONCLICK PARA EL BOTON DE ELIMINAR*/
	$(document).on('click', '[id^="btnEliminar-"]', function() {
		var $button = $(this);
		var id = this.id.split('-').pop();

		var table = $('#tblBeneficios').DataTable(); // replace with your table id        

		const swalWithBootstrapButtons = Swal.mixin({
			customClass: {
				confirmButton: 'btn btn-success',
				cancelButton: 'btn btn-danger'
			},
			buttonsStyling: false
		})

		const Toast = Swal.mixin({
			toast: true,
			position: 'top-end',
			showConfirmButton: false,
			timer: 3000,
			timerProgressBar: true,
			didOpen: (toast) => {
				toast.addEventListener('mouseenter', Swal.stopTimer)
				toast.addEventListener('mouseleave', Swal.resumeTimer)
			}
		})

		swalWithBootstrapButtons.fire({
			title: '¿Desea eliminar el siguiente registro?',
			text: "Esta acción no es reversible.",
			icon: 'warning',
			showCancelButton: true,
			confirmButtonText: 'Sí, Eliminar',
			cancelButtonText: 'No, cancelar',
			reverseButtons: true
		}).then((result) => {
			if (result.isConfirmed) {

				var token = $("meta[name='csrf-token']").attr("content");

				$.ajax({
					url: "<?php echo e(url('beneficios')); ?>" + "/" + id,
					type: 'DELETE',
					data: {
						_token: '<?php echo e(csrf_token()); ?>',
					},
					success: function() {
						table.row($button.parents('tr')).remove().draw();
						Toast.fire({
							icon: 'success',
							title: 'Registro eliminado'
						})

					}
				});
			}
		})

	});
</script>

<table class="table border" id="tblBeneficios">
	<thead>
		<tr>
			<th>Estado</th>
			<th>Nombre</th>
			<th>Descripción</th>
			<th>Código</th>
			<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('editar_beneficios')): ?>
			<th>Editar</th>
			<?php endif; ?>
			<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('eliminar_beneficios')): ?>
			<th>Eliminar</th>
			<?php endif; ?>
		</tr>
	</thead>
	<tbody>
		<?php $__currentLoopData = $beneficios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $beneficio): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
		<tr>
			<td><?php echo e($beneficio->estado); ?></td>
			<td><?php echo e($beneficio->nombre); ?></td>
			<td><?php echo e($beneficio->descripcion); ?></td>
			<td><?php echo e($beneficio->codigo); ?> </td>
			<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('editar_beneficios')): ?>
			<td>
				<a class="btn btn-warning" href="<?php echo e(url('/beneficios/'.$beneficio->id.'/edit')); ?>">
					<i class="fa-solid fa-pen-to-square"></i>
				</a>
			</td>
			<?php endif; ?>
			<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('eliminar_beneficios')): ?>
			<td>
				<button class="btn btn-danger" id="btnEliminar-<?php echo e($beneficio->id); ?>"><i class="fa-solid fa-circle-minus"></i></button>
			</td>
			<?php endif; ?>
		</tr>
		<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
	</tbody>
</table><?php /**PATH /home/fyiusr/public_html/qa-foliatti.itiapp.fyi/resources/views/Beneficios/beneficios_list.blade.php ENDPATH**/ ?>